/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.client.api.artifact.dsl;

import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.mule.metadata.api.model.MetadataType;

public class DslElementSyntax {
    private final String attributeName;
    private final String elementName;
    private final String prefix;
    private final String namespace;
    private final boolean isWrapped;
    private final boolean supportsAttributeDeclaration;
    private final boolean supportsChildDeclaration;
    private final boolean supportsTopLevelDeclaration;
    private final boolean requiresConfig;
    private final Map<MetadataType, DslElementSyntax> genericsDsl;
    private final Map<String, DslElementSyntax> childs;
    private final Map<String, DslElementSyntax> attributes;
    private final Map<String, DslElementSyntax> containedElements;

    public DslElementSyntax(String attributeName, String elementName, String prefix, String namespace, boolean isWrapped, boolean supportsAttributeDeclaration, boolean supportsChildDeclaration, boolean supportsTopLevelDeclaration, boolean requiresConfig, Map<MetadataType, DslElementSyntax> genericsDsl, Map<String, DslElementSyntax> containedElements) {
        this.attributeName = attributeName;
        this.elementName = elementName;
        this.prefix = prefix;
        this.namespace = namespace;
        this.isWrapped = isWrapped;
        this.supportsAttributeDeclaration = supportsAttributeDeclaration;
        this.supportsChildDeclaration = supportsChildDeclaration;
        this.supportsTopLevelDeclaration = supportsTopLevelDeclaration;
        this.requiresConfig = requiresConfig;
        this.genericsDsl = genericsDsl;
        this.containedElements = containedElements;
        this.childs = containedElements.entrySet().stream().filter(e -> ((DslElementSyntax)e.getValue()).supportsChildDeclaration()).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
        this.attributes = containedElements.entrySet().stream().filter(e -> ((DslElementSyntax)e.getValue()).supportsAttributeDeclaration()).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
    }

    public String getElementName() {
        return this.elementName;
    }

    public String getPrefix() {
        return this.prefix;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public boolean isWrapped() {
        return this.isWrapped;
    }

    public String getAttributeName() {
        return this.attributeName;
    }

    public boolean supportsAttributeDeclaration() {
        return this.supportsAttributeDeclaration;
    }

    public boolean supportsChildDeclaration() {
        return this.supportsChildDeclaration;
    }

    public boolean supportsTopLevelDeclaration() {
        return this.supportsTopLevelDeclaration;
    }

    public boolean requiresConfig() {
        return this.requiresConfig;
    }

    public Optional<DslElementSyntax> getGeneric(MetadataType type) {
        return Optional.ofNullable(this.genericsDsl.get(type));
    }

    public Map<MetadataType, DslElementSyntax> getGenerics() {
        return this.genericsDsl;
    }

    public Optional<DslElementSyntax> getChild(String name) {
        return Optional.ofNullable(this.childs.get(name));
    }

    public List<DslElementSyntax> getChilds() {
        return ImmutableList.copyOf(this.childs.values());
    }

    public Optional<DslElementSyntax> getAttribute(String name) {
        return Optional.ofNullable(this.attributes.get(name));
    }

    public List<DslElementSyntax> getAttributes() {
        return ImmutableList.copyOf(this.attributes.values());
    }

    public Optional<DslElementSyntax> getContainedElement(String name) {
        return Optional.ofNullable(this.containedElements.get(name));
    }

    public List<DslElementSyntax> getContainedElements() {
        return ImmutableList.copyOf(this.containedElements.values());
    }

    public boolean equals(Object o) {
        return EqualsBuilder.reflectionEquals((Object)this, (Object)o, (String[])new String[0]);
    }

    public int hashCode() {
        return HashCodeBuilder.reflectionHashCode((Object)this, (String[])new String[0]);
    }

    public String toString() {
        return "{ \nAttributeName: " + this.attributeName + ",\nElementName: " + this.elementName + ",\nPrefix: " + this.prefix + ",\nNamespace: " + this.namespace + ",\nSupportsAttributeDeclaration: " + this.supportsAttributeDeclaration + ",\nSupportsChildDeclaration: " + this.supportsChildDeclaration + ",\nSupportsTopLevelDeclaration: " + this.supportsTopLevelDeclaration + ",\nRequiresConfig: " + this.requiresConfig + "}";
    }
}

