/*
 * Copyright (c) MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */

package org.mule.tooling.client.api.connectivity;

import org.mule.runtime.api.message.ErrorType;

/**
 * Result of a test connection.
 *
 * @since 1.0
 */
public interface ConnectionValidationResult {

  /**
   * @return {@code true} if the test connection was successful otherwise {@code false}.
   */
  boolean isValid();

  /**
   * @return {@link String} message describing the reason why the test connection failure.
   */
  String getMessage();

  /**
   * @return {@link ConnectionExceptionCode} for the test connection failure.
   */
  ErrorType getErrorType();

  /**
   * @return {@link String} with the stack trace of the exception that caused the test connection failure.
   */
  String getException();
}
