/*
 * Copyright (c) MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */

package org.mule.tooling.client.api.tryit;

import java.util.Map;

/**
 * Immutable implementation of {@link Notification}.
 *
 * @since 1.0
 */
public class ImmutableNotification implements Notification {

  private String application;
  private long timestamp;
  private NotificationAction action;
  private String component;
  private Message message;
  private String componentPath;
  private String correlationId;
  private Map<String, TypedValue> variables;

  private ImmutableNotification() {}

  /**
   * Creates a builder for the {@link ImmutableNotification} object.
   *
   * @return a new builder.
   */
  public static Builder builder() {
    return new Builder();
  }

  @Override
  public String getApplication() {
    return application;
  }

  @Override
  public long getTimestamp() {
    return timestamp;
  }

  @Override
  public NotificationAction getAction() {
    return action;
  }

  @Override
  public String getComponent() {
    return component;
  }

  @Override
  public Message getMessage() {
    return message;
  }

  @Override
  public String getComponentPath() {
    return componentPath;
  }

  @Override
  public String getCorrelationId() {
    return correlationId;
  }

  @Override
  public Map<String, TypedValue> getVariables() {
    return variables;
  }

  /**
   * Builder for creating {@link ImmutableNotification} objects.
   */
  public static class Builder {

    private ImmutableNotification immutableNotification;

    private Builder() {
      immutableNotification = new ImmutableNotification();
    }

    public Builder applicationName(String application) {
      immutableNotification.application = application;
      return this;
    }

    public Builder timestamp(long timestamp) {
      immutableNotification.timestamp = timestamp;
      return this;
    }

    public Builder action(NotificationAction action) {
      immutableNotification.action = action;
      return this;
    }

    public Builder component(String component) {
      immutableNotification.component = component;
      return this;
    }

    public Builder message(Message message) {
      immutableNotification.message = message;
      return this;
    }

    public Builder componentPath(String componentPath) {
      immutableNotification.componentPath = componentPath;
      return this;
    }

    public Builder correlationId(String correlationId) {
      immutableNotification.correlationId = correlationId;
      return this;
    }

    public Builder variables(Map<String, TypedValue> variables) {
      immutableNotification.variables = variables;
      return this;
    }

    public ImmutableNotification build() {
      return immutableNotification;
    }

  }
}
