/*
 * Copyright (c) MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */

package org.mule.tooling.client.api.artifact;

import org.mule.runtime.api.app.declaration.ArtifactDeclaration;
import org.mule.tooling.client.api.connectivity.ConnectivityTestingService;

/**
 * Builder that creates a dynamically {@link ConnectivityTestingService}.
 *
 * @since 1.0
 */
public interface ConnectivityTestingServiceBuilder {

  /**
   * Adds an dependency to the artifact. It has to be a Maven coordinate for a JAR artifact only.
   *
   * @param groupId group id of the Maven artifact
   * @param artifactId artifact id of Maven artifact
   * @param version version of the Maven artifact
   * @param classifier classifier of the Maven artifact
   * @param type type of the Maven artifact
   * @return this
   */
  ConnectivityTestingServiceBuilder addDependency(String groupId, String artifactId, String version, String classifier,
                                                  String type);

  /**
   * Configures the mule components for the application.
   *
   * @param artifactDeclaration the {@link ArtifactDeclaration} that defines the application used for connectivity testing
   * @return this
   */
  ConnectivityTestingServiceBuilder setArtifactDeclaration(ArtifactDeclaration artifactDeclaration);

  /**
   * Creates a {@link ConnectivityTestingService} with the provided configuration.
   *
   * @return the {@link ConnectivityTestingService}.
   */
  ConnectivityTestingService build();
}
