/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.client.api.extension.model;

import java.util.Objects;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.mule.tooling.client.internal.util.Preconditions;

public class StereotypeModel {
    private String name;
    private String namespace;
    private StereotypeModel parent;

    private StereotypeModel() {
    }

    public StereotypeModel(String name, String namespace, StereotypeModel parent) {
        Preconditions.checkState(StringUtils.isNotBlank((CharSequence)name), "name cannot be null");
        Preconditions.checkState(StringUtils.isNotBlank((CharSequence)namespace), "namespace cannot be null");
        this.name = name;
        this.namespace = namespace;
        this.parent = parent;
    }

    public String getName() {
        return this.name;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public Optional<StereotypeModel> getParent() {
        return Optional.ofNullable(this.parent);
    }

    public boolean isProcessor() {
        return this.isAssignableTo(new StereotypeModel("PROCESSOR", "MULE", null));
    }

    public boolean isSource() {
        return this.isAssignableTo(new StereotypeModel("SOURCE", "MULE", null));
    }

    public boolean isModuleConfig() {
        return this.isAssignableTo(new StereotypeModel("MODULE_CONFIG", "MULE", null));
    }

    public boolean isFlow() {
        return this.isAssignableTo(new StereotypeModel("FLOW", "MULE", null));
    }

    public boolean isObjectStore() {
        return this.isAssignableTo(new StereotypeModel("OBJECT_STORE", "OS", null));
    }

    public boolean isConnection() {
        return this.isAssignableTo(new StereotypeModel("CONNECTION", "MULE", null));
    }

    public boolean isAssignableTo(StereotypeModel other) {
        Preconditions.checkArgument(other != null, "Null is not a valid stereotype");
        boolean assignable = this.equals(other);
        if (!assignable && this.parent != null) {
            assignable = this.parent.isAssignableTo(other);
        }
        return assignable;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof StereotypeModel)) {
            return false;
        }
        return Objects.equals(this.name, ((StereotypeModel)obj).getName()) && Objects.equals(this.namespace, ((StereotypeModel)obj).getNamespace());
    }

    public int hashCode() {
        return this.name.hashCode();
    }
}

