/*
 * Copyright (c) MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */

package org.mule.tooling.client.api;

import org.mule.maven.client.api.MavenClient;
import org.mule.tooling.client.api.ToolingRuntimeClient.Builder;

/**
 * Factory for creating a {@link Builder}. Uses SPI to discover the implementation.
 *
 * @since 1.0
 */
public abstract class AbstractToolingRuntimeClientBuilderFactory implements Disposable {

  /**
   * Creates a factory.
   */
  public AbstractToolingRuntimeClientBuilderFactory() {}

  /**
   * Creates a {@link Builder}.
   *
   * @return {@link Builder} to create a {@link ToolingRuntimeClient}.
   * @param mavenClient client to use to access maven repository
   */
  public abstract Builder create(MavenClient mavenClient);

}
