/*
 * Copyright (c) MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.tooling.client.api.dataweave.validation;

public class DataWeaveValidationRequest {

  private String script;

  public DataWeaveValidationRequest(String script) {
    this.script = script;
  }

  public String getScript() {
    return script;
  }

  // ***********************************************************************************
  // ============== Builder class =================
  // ***********************************************************************************

  public static DataWeaveValidationRequest.Builder builder() {
    return new Builder();
  }

  public static class Builder {

    private String script;

    private Builder() {
      // only accessible using the factory method
    }

    public Builder withScript(String script) {
      this.script = script;
      return this;
    }

    public DataWeaveValidationRequest build() {
      return new DataWeaveValidationRequest(script);
    }
  }
}
