/*
 * Copyright (c) MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */

package org.mule.tooling.client.api.tryit;

/**
 * Immutable implementation for {@link DataType}.
 *
 * @since 1.0
 */
public class ImmutableDataType implements DataType {

  private String type;
  private String mediaType;

  private ImmutableDataType() {}

  /**
   * Creates a builder for the {@link ImmutableDataType} object.
   *
   * @return a new builder.
   */
  public static Builder builder() {
    return new Builder();
  }

  @Override
  public String getType() {
    return this.type;
  }

  @Override
  public String getMediaType() {
    return this.mediaType;
  }

  /**
   * Builder for creating {@link ImmutableDataType} objects.
   */
  public static class Builder {

    private ImmutableDataType instance;

    private Builder() {
      instance = new ImmutableDataType();
    }

    public Builder type(String type) {
      instance.type = type;
      return this;
    }

    public Builder mediaType(String mediaType) {
      instance.mediaType = mediaType;
      return this;
    }

    public ImmutableDataType build() {
      return instance;
    }
  }

}
