/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.client.api.extension.model.parameter;

import java.util.List;
import java.util.Optional;
import org.apache.commons.lang3.builder.ReflectionToStringBuilder;
import org.mule.metadata.api.model.MetadataType;
import org.mule.tooling.client.api.extension.model.DisplayModel;
import org.mule.tooling.client.api.extension.model.ExpressionSupport;
import org.mule.tooling.client.api.extension.model.LayoutModel;
import org.mule.tooling.client.api.extension.model.ParameterDslConfiguration;
import org.mule.tooling.client.api.extension.model.StereotypeModel;
import org.mule.tooling.client.api.extension.model.metadata.MetadataKeyPartModel;
import org.mule.tooling.client.api.extension.model.parameter.ParameterRole;
import org.mule.tooling.client.api.extension.model.value.ValueProviderModel;

public final class ParameterModel {
    private String name;
    private String description;
    private DisplayModel displayModel;
    private MetadataType type;
    private boolean hasDynamicType;
    private boolean required;
    private boolean isConfigOverride;
    private ExpressionSupport expressionSupport;
    private Object defaultValue;
    private ParameterRole role;
    private ParameterDslConfiguration dslConfiguration;
    private LayoutModel layoutModel;
    private MetadataKeyPartModel metadataKeyPartModel;
    private ValueProviderModel valueProviderModel;
    private List<StereotypeModel> allowedStereotypes;

    private ParameterModel() {
    }

    public ParameterModel(String name, String description, DisplayModel displayModel, MetadataType type, boolean hasDynamicType, boolean required, boolean isConfigOverride, ExpressionSupport expressionSupport, Object defaultValue, ParameterRole role, ParameterDslConfiguration dslConfiguration, LayoutModel layoutModel, MetadataKeyPartModel metadataKeyPartModel, ValueProviderModel valueProviderModel, List<StereotypeModel> allowedStereotypes) {
        this.name = name;
        this.description = description;
        this.displayModel = displayModel;
        this.type = type;
        this.hasDynamicType = hasDynamicType;
        this.required = required;
        this.isConfigOverride = isConfigOverride;
        this.expressionSupport = expressionSupport;
        this.defaultValue = defaultValue;
        this.role = role;
        this.dslConfiguration = dslConfiguration;
        this.layoutModel = layoutModel;
        this.metadataKeyPartModel = metadataKeyPartModel;
        this.valueProviderModel = valueProviderModel;
        this.allowedStereotypes = allowedStereotypes;
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public Optional<DisplayModel> getDisplayModel() {
        return Optional.ofNullable(this.displayModel);
    }

    public MetadataType getType() {
        return this.type;
    }

    public boolean hasDynamicType() {
        return this.hasDynamicType;
    }

    public boolean isRequired() {
        return this.required;
    }

    public boolean isOverrideFromConfig() {
        return this.isConfigOverride;
    }

    public ExpressionSupport getExpressionSupport() {
        return this.expressionSupport;
    }

    public Object getDefaultValue() {
        return this.defaultValue;
    }

    public ParameterDslConfiguration getDslConfiguration() {
        return this.dslConfiguration;
    }

    public ParameterRole getRole() {
        return this.role;
    }

    public Optional<LayoutModel> getLayoutModel() {
        return Optional.ofNullable(this.layoutModel);
    }

    public Optional<MetadataKeyPartModel> getMetadataKeyPartModel() {
        return Optional.ofNullable(this.metadataKeyPartModel);
    }

    public Optional<ValueProviderModel> getValueProviderModel() {
        return Optional.ofNullable(this.valueProviderModel);
    }

    public List<StereotypeModel> getAllowedStereotypes() {
        return this.allowedStereotypes;
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public boolean equals(Object obj) {
        return this.getClass().isInstance(obj) && this.name.equals(((ParameterModel)obj).getName());
    }

    public String toString() {
        return ReflectionToStringBuilder.toString((Object)this);
    }
}

