/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.client.api.metadata;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.mule.tooling.client.api.metadata.MetadataFailure;

public final class MetadataResult<T> {
    T value;
    List<MetadataFailure> failures;

    private MetadataResult(T value, List<MetadataFailure> failures) {
        this.value = value;
        this.failures = failures;
    }

    public static <T> MetadataResult<T> success(T payload) {
        return new MetadataResult<T>(payload, Collections.emptyList());
    }

    public static <T> MetadataResult<T> failure(MetadataFailure ... failures) {
        return new MetadataResult<Object>(null, Arrays.asList(failures));
    }

    public static <T> MetadataResult<T> failure(List<MetadataFailure> failures) {
        return new MetadataResult<Object>(null, failures);
    }

    public T get() {
        return this.value;
    }

    public boolean isSuccess() {
        return this.failures == null || this.failures.isEmpty();
    }

    public List<MetadataFailure> getFailures() {
        return this.failures;
    }
}

