/*
 * Copyright (c) MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.tooling.client.api.extension.model;

import org.mule.tooling.client.api.types.UnknownType;

/**
 * Represents the kind of category that a plugin can be assigned to.
 * <p>
 * <ul>
 * <li>{@link #isCommunity}: Represents that the plugin does not requires an Enterprise Mule Runtime to work.</li>
 * <li>{@link #isSelect}: Represents that the plugin requires an Enterprise Mule Runtime to work.</li>
 * <li>{@link #isPremium}: Represents that the plugin requires an Enterprise Mule Runtime to work and also
 * an plugin entitlement to work</li>
 * <li>{@link #isCertified}: Represent that the plugin is MuleSoft certified and requires an Enterprise Mule
 * Runtime to work</li>
 * </ul>
 *
 * @since 1.0
 */
public class Category extends UnknownType {

  private boolean community;
  private boolean select;
  private boolean premium;
  private boolean certified;

  // Just needed in order to serialize this object
  private Category() {}

  public Category(String value, boolean unknown, boolean community, boolean select, boolean premium, boolean certified) {
    super(value, unknown);
    this.community = community;
    this.select = select;
    this.premium = premium;
    this.certified = certified;
  }

  public boolean isCommunity() {
    return community;
  }

  public boolean isSelect() {
    return select;
  }

  public boolean isPremium() {
    return premium;
  }

  public boolean isCertified() {
    return certified;
  }

}
