/*
 * Copyright (c) MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */

package org.mule.tooling.client.api.extension.model;

import org.mule.tooling.client.api.types.UnknownType;

/**
 * Represents the different types of external libraries an extension may require.
 *
 * @since 1.0
 */
public class ExternalLibraryType extends UnknownType {

  private boolean nativeLibrary;
  private boolean jar;
  private boolean dependency;

  // Just needed in order to serialize this object
  private ExternalLibraryType() {}

  public ExternalLibraryType(String value, boolean unknown, boolean nativeLibrary, boolean jar, boolean dependency) {
    super(value, unknown);
    this.nativeLibrary = nativeLibrary;
    this.jar = jar;
    this.dependency = dependency;
  }

  /**
   * @return {@code true} if native library.
   */
  public boolean isNativeLibrary() {
    return nativeLibrary;
  }

  /**
   * @return {@code true} if jar file.
   */
  public boolean isJar() {
    return jar;
  }

  /**
   * @return {@code true} if external dependencies.
   */
  public boolean isDependency() {
    return dependency;
  }

}
