/*
 * Copyright (c) MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */

package org.mule.tooling.client.api.extension.model;

import org.mule.tooling.client.api.types.UnknownType;

/**
 * Represents the type of a {@link PathModel}.
 *
 * @since 1.0
 */
public class PathModelType extends UnknownType {

  private boolean directory;
  private boolean file;
  private boolean any;

  // Just needed in order to serialize this object
  private PathModelType() {}

  public PathModelType(String value, boolean unknown, boolean directory, boolean file, boolean any) {
    super(value, unknown);
    this.directory = directory;
    this.file = file;
    this.any = any;
  }

  public boolean isDirectory() {
    return directory;
  }

  public boolean isFile() {
    return file;
  }

  public boolean isAny() {
    return any;
  }

}
