/*
 * Copyright (c) MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */

package org.mule.tooling.client.api.metadata;

import static java.lang.String.format;
import static java.util.Objects.requireNonNull;
import static org.apache.commons.lang3.ClassUtils.getShortClassName;
import org.mule.runtime.api.component.location.Location;
import org.mule.runtime.api.metadata.MetadataKeysContainer;
import org.mule.tooling.client.api.artifact.ToolingArtifact;
import org.mule.tooling.client.api.request.AbstractToolingRequest;

/**
 * Request entity for retrieving {@link MetadataKeysContainer} for a {@link ToolingArtifact}.
 *
 * @since 1.0
 */
public final class MetadataKeysRequest extends AbstractToolingRequest {

  private Location location;

  /**
   * Sets the location path of the {@link org.mule.runtime.api.metadata.MetadataKeyProvider} component inside the flow.
   *
   * @param location the location path of the {@link org.mule.runtime.api.metadata.MetadataKeyProvider} component inside the flow.
   */
  public void setLocation(Location location) {
    requireNonNull(location, "componentPath cannot null");
    this.location = location;
  }

  /**
   * @return the location path of the {@link org.mule.runtime.api.metadata.MetadataKeyProvider} component inside the flow.
   */
  public Location getLocation() {
    return location;
  }

  @Override
  public String toString() {
    return format("%s{requestTimeout=%s,componentLocation=%s}", getShortClassName(this.getClass()), getRequestTimeout(),
                  location);
  }

}
