/*
 * Copyright (c) MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */

package org.mule.tooling.client.api.metadata.dto;

/**
 * Standard error codes to describe common errors that may occur during
 * Metadata fetching operations
 *
 * @since 1.0
 */
public final class FailureCode {

  public static final FailureCode UNKNOWN = new FailureCode("UNKNOWN");
  public static final FailureCode COMPONENT_NOT_FOUND = new FailureCode("COMPONENT_NOT_FOUND");

  private final String name;

  public FailureCode(String name) {
    this.name = name;
  }

  public String getName() {
    return name;
  }

  @Override
  public boolean equals(Object obj) {
    return obj instanceof FailureCode && this.getName().equals(((FailureCode) obj).getName());
  }

  @Override
  public int hashCode() {
    return name.hashCode();
  }

  @Override
  public String toString() {
    return getName();
  }

}
