/*
 * Copyright (c) MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.tooling.client.api.metadata.dto;

import org.mule.tooling.client.api.types.UnknownType;

/**
 * Enumerates all the components that can be retrieved in a {@link MetadataResult}.
 *
 * @since 1.0
 */
public class MetadataComponent extends UnknownType {

  private boolean outputAttribute;
  private boolean outputPayload;
  private boolean input;
  private boolean component;
  private boolean entity;
  private boolean keys;

  // Just needed in order to serialize this object
  private MetadataComponent() {}

  public MetadataComponent(String value, boolean unkown, boolean outputAttribute, boolean outputPayload, boolean input,
                           boolean component, boolean entity, boolean keys) {
    super(value, unkown);
    this.outputAttribute = outputAttribute;
    this.outputPayload = outputPayload;
    this.input = input;
    this.component = component;
    this.entity = entity;
    this.keys = keys;
  }

  public boolean isOutputAttribute() {
    return outputAttribute;
  }

  public boolean isOutputPayload() {
    return outputPayload;
  }

  public boolean isComponent() {
    return component;
  }

  public boolean isEntity() {
    return entity;
  }

  public boolean isInput() {
    return input;
  }

  public boolean isKeys() {
    return keys;
  }
}
