/*
 * Copyright (c) MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */

package org.mule.tooling.client.api.extension.model.operation;

import org.mule.tooling.client.api.extension.model.DisplayModel;
import org.mule.tooling.client.api.extension.model.ErrorModel;
import org.mule.tooling.client.api.extension.model.OutputModel;
import org.mule.tooling.client.api.extension.model.Stereotype;
import org.mule.tooling.client.api.extension.model.parameter.ParameterGroupModel;

import java.util.List;
import java.util.Set;

/**
 * An specification which represents the particular case of a
 * scope, such as async or foreach.
 * <p>
 *
 * @since 1.0
 */
public class ScopeModel extends OperationModel {

  // Just needed in order to serialize this object
  private ScopeModel() {}

  public ScopeModel(String name, String description,
                    List<ParameterGroupModel> parameterGroupModels,
                    DisplayModel displayModel, boolean blocking,
                    Set<ErrorModel> errors,
                    OutputModel output,
                    OutputModel outputAttributes, boolean transaction,
                    boolean requiresConnection, boolean supportsStreaming,
                    Set<Stereotype> stereotypes) {
    super(name, description, parameterGroupModels, displayModel, blocking, errors, output, outputAttributes, transaction,
          requiresConnection, supportsStreaming, stereotypes);
  }

}
