/*
 * Copyright (c) MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */

package org.mule.tooling.client.api.extension.model.parameter;

import org.mule.tooling.client.api.types.UnknownType;

/**
 * A model which provides directives for parameters that points to another components like a config or flow.
 */
public class ElementReference extends UnknownType {

  private String namespace;
  private String name;
  private boolean isConfig = false;
  private boolean isFlow = false;

  private ElementReference() {}

  public ElementReference(String value, String namespace, String name) {
    super(value);
    this.namespace = namespace;
    this.name = name;
    this.isConfig = isConfig;
    this.isFlow = isFlow;
  }

  public static ElementReference configElementReference(String value, String namespace, String name) {
    ElementReference elementReference = new ElementReference(value, namespace, name);
    elementReference.isConfig = true;
    return elementReference;
  }

  public static ElementReference flowElementReference(String value, String namespace, String name) {
    ElementReference elementReference = new ElementReference(value, namespace, name);
    elementReference.isFlow = true;
    return elementReference;
  }

  public boolean isConfig() {
    return isConfig;
  }

  public boolean isFlow() {
    return isFlow;
  }

  public String getNamespace() {
    return namespace;
  }

  public String getName() {
    return name;
  }
}
