/*
 * Copyright (c) MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */

package org.mule.tooling.client.api.extension.model.parameter;

import static org.apache.commons.lang3.builder.EqualsBuilder.reflectionEquals;
import static org.apache.commons.lang3.builder.HashCodeBuilder.reflectionHashCode;

import java.util.Set;

import org.apache.commons.lang3.builder.ReflectionToStringBuilder;

/**
 * Indicates that some of the optional {@link ParameterModel parameters} in a
 * {@link ParameterGroupModel} are mutually exclusive and cannot be defined at the same time.
 *
 * @since 1.0
 */
public final class ExclusiveParametersModel {

  private Set<String> exclusiveParameterNames;
  private boolean isOneRequired;

  // Just needed in order to serialize this object
  private ExclusiveParametersModel() {}

  public ExclusiveParametersModel(Set<String> exclusiveParameterNames, boolean isOneRequired) {
    this.exclusiveParameterNames = exclusiveParameterNames;
    this.isOneRequired = isOneRequired;
  }

  public Set<String> getExclusiveParameterNames() {
    return exclusiveParameterNames;
  }

  public boolean isOneRequired() {
    return isOneRequired;
  }

  public int hashCode() {
    return reflectionHashCode(this);
  }

  public boolean equals(Object obj) {
    return reflectionEquals(this, obj);
  }

  public String toString() {
    return ReflectionToStringBuilder.toString(this);
  }

}
