/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.client.api.dataweave.validation;

public class DataWeaveValidationError {
    private final int startIndex;
    private final int startLine;
    private final int endIndex;
    private final int endLine;
    private final String message;

    private DataWeaveValidationError(int startIndex, int startLine, int endIndex, int endLine, String message) {
        this.startIndex = startIndex;
        this.startLine = startLine;
        this.endIndex = endIndex;
        this.endLine = endLine;
        this.message = message;
    }

    public String getMessage() {
        return this.message;
    }

    public int getEndLine() {
        return this.endLine;
    }

    public int getEndIndex() {
        return this.endIndex;
    }

    public int getStartLine() {
        return this.startLine;
    }

    public int getStartIndex() {
        return this.startIndex;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private String message;
        private int startIndex;
        private int startLine;
        private int endIndex;
        private int endLine;

        private Builder() {
        }

        public DataWeaveValidationError build() {
            return new DataWeaveValidationError(this.startIndex, this.startLine, this.endIndex, this.endLine, this.message);
        }

        public Builder withMessage(String message) {
            this.message = message;
            return this;
        }

        public Builder withStartIndex(int startIndex) {
            this.startIndex = startIndex;
            return this;
        }

        public Builder withStartLine(int startLine) {
            this.startLine = startLine;
            return this;
        }

        public Builder withEndIndex(int endIndex) {
            this.endIndex = endIndex;
            return this;
        }

        public Builder withEndLine(int endLine) {
            this.endLine = endLine;
            return this;
        }
    }
}

