/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.client.api.datasense;

import java.util.Optional;
import org.mule.tooling.client.api.datasense.DataSenseNotificationType;
import org.mule.tooling.client.api.datasense.I18nMessage;
import org.mule.tooling.client.api.location.ComponentLocation;
import org.mule.tooling.client.api.metadata.FailureCode;
import org.mule.tooling.client.api.metadata.MetadataComponent;

public class DataSenseNotification {
    private DataSenseNotificationType type;
    private MetadataComponent metadataComponent;
    private String failingElement;
    private FailureCode failureCode;
    private I18nMessage message;
    private I18nMessage reason;
    private ComponentLocation componentLocation;

    private DataSenseNotification() {
    }

    public DataSenseNotification(DataSenseNotificationType type, MetadataComponent component, String failingElement, FailureCode failureCode, I18nMessage message, I18nMessage reason, ComponentLocation componentLocation) {
        this.type = type;
        this.metadataComponent = component;
        this.failingElement = failingElement;
        this.failureCode = failureCode;
        this.message = message;
        this.reason = reason;
        this.componentLocation = componentLocation;
    }

    public DataSenseNotificationType getNotificationType() {
        return this.type;
    }

    public Optional<ComponentLocation> getComponentLocation() {
        return Optional.ofNullable(this.componentLocation);
    }

    public Optional<MetadataComponent> getMetadataComponent() {
        return Optional.ofNullable(this.metadataComponent);
    }

    public Optional<String> getFailingElement() {
        return Optional.ofNullable(this.failingElement);
    }

    public Optional<FailureCode> getFailureCode() {
        return Optional.ofNullable(this.failureCode);
    }

    public I18nMessage getMessage() {
        return this.message;
    }

    public Optional<I18nMessage> getReason() {
        return Optional.ofNullable(this.reason);
    }
}

