/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.client.internal.configuration.agent;

import java.net.URL;
import java.util.Optional;
import javax.net.ssl.SSLContext;
import org.mule.tooling.client.api.configuration.agent.AgentConfiguration;

public class ImmutableAgentConfiguration
implements AgentConfiguration {
    private URL toolingApiUrl;
    private int defaultConnectionTimeout;
    private int defaultReadTimeout;
    private SSLContext sslContext;

    public ImmutableAgentConfiguration(URL toolingApiUrl, int defaultConnectionTimeout, int defaultReadTimeout, SSLContext sslContext) {
        this.toolingApiUrl = toolingApiUrl;
        this.defaultConnectionTimeout = defaultConnectionTimeout;
        this.defaultReadTimeout = defaultReadTimeout;
        this.sslContext = sslContext;
    }

    @Override
    public URL getToolingApiUrl() {
        return this.toolingApiUrl;
    }

    @Override
    public int getDefaultConnectTimeout() {
        return this.defaultConnectionTimeout;
    }

    @Override
    public int getDefaultReadTimeout() {
        return this.defaultReadTimeout;
    }

    @Override
    public Optional<SSLContext> getSSLContext() {
        return Optional.ofNullable(this.sslContext);
    }

    public String toString() {
        return String.format("%s{toolingApiUrl=%s,defaultConnectionTimeout=%sms, defaultReadTimeout=%sms}", this.getClass().getName(), this.toolingApiUrl, this.defaultConnectionTimeout, this.defaultReadTimeout);
    }
}

