/*
 * Copyright (c) MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */

package org.mule.tooling.client.api.extension.model.function;

import static java.util.Optional.ofNullable;
import org.mule.tooling.client.api.extension.model.DisplayModel;
import org.mule.tooling.client.api.extension.model.ExtensionModel;
import org.mule.tooling.client.api.extension.model.OutputModel;
import org.mule.tooling.client.api.extension.model.parameter.ParameterGroupModel;

import java.util.List;
import java.util.Optional;

import org.apache.commons.lang3.builder.ReflectionToStringBuilder;

/**
 * A definition of an operation in a {@link ExtensionModel}.
 *
 * @since 1.0
 */
public class FunctionModel {

  private String name;
  private String description;
  private List<ParameterGroupModel> parameterGroupModels;
  private DisplayModel displayModel;
  private OutputModel output;

  // Just needed in order to serialize this object
  protected FunctionModel() {}

  public FunctionModel(String name, String description,
                       List<ParameterGroupModel> parameterGroupModels,
                       DisplayModel displayModel, OutputModel output) {
    this.name = name;
    this.description = description;
    this.parameterGroupModels = parameterGroupModels;
    this.displayModel = displayModel;
    this.output = output;
  }

  public String getName() {
    return name;
  }

  public String getDescription() {
    return description;
  }

  public List<ParameterGroupModel> getParameterGroupModels() {
    return parameterGroupModels;
  }

  public Optional<DisplayModel> getDisplayModel() {
    return ofNullable(displayModel);
  }

  public OutputModel getOutput() {
    return output;
  }

  @Override
  public int hashCode() {
    return this.name.hashCode();
  }

  @Override
  public boolean equals(Object obj) {
    return this.getClass().isInstance(obj) && this.name.equals(((FunctionModel) obj).getName());
  }

  @Override
  public String toString() {
    return ReflectionToStringBuilder.toString(this);
  }

}
