/*
 * Copyright (c) MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.tooling.client.api.extension.model.nested;


import org.mule.tooling.client.api.extension.model.DisplayModel;
import org.mule.tooling.client.api.extension.model.Stereotype;

import java.util.Set;

/**
 * Represents a {@link NestableElementModel} that makes reference to a chain of ComponentModels.
 * This chain can have any number of components of the allowed stereotypes.
 *
 * @since 1.0
 */
public class NestedChainModel extends NestedComponentModel {

  public NestedChainModel() {}

  /**
   * Creates a new instance
   *
   * @param name            the model's name
   * @param description     the model's description
   * @param isRequired      whether or not this component is required
   * @param allowedStereotypes     A {@link Set} of custom properties which extend this model
   * @param displayModel    a model containing directives about how this component is to be displayed in the UI
   * @throws IllegalArgumentException if {@code name} is blank
   */
  public NestedChainModel(String name, String description, DisplayModel displayModel,
                          boolean isRequired, Set<Stereotype> allowedStereotypes) {
    super(name, description, displayModel, isRequired, allowedStereotypes);
  }

}
