/*
 * Copyright (c) MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.tooling.client.api.datasense;

import org.mule.tooling.client.api.extension.model.operation.OperationModel;
import org.mule.tooling.client.api.extension.model.source.SourceModel;

import java.util.List;
import java.util.Optional;

import static java.util.Optional.ofNullable;

public class DataSenseComponentInfo {

  private OperationModel operationModel;
  private SourceModel sourceModel;
  private List<String> messages;
  private List<DataSenseNotification> notifications;

  private DataSenseComponentInfo() {}

  public DataSenseComponentInfo(OperationModel operationModel, SourceModel sourceModel, List<String> messages,
                                List<DataSenseNotification> notifications) {
    this.operationModel = operationModel;
    this.sourceModel = sourceModel;
    this.messages = messages;
    this.notifications = notifications;
  }


  public Optional<OperationModel> getOperationModel() {
    return ofNullable(operationModel);
  }

  public Optional<SourceModel> getSourceModel() {
    return ofNullable(sourceModel);
  }

  public List<String> getMessages() {
    return messages;
  }

  public List<DataSenseNotification> getDataSenseNotifications() {
    return notifications;
  }
}
