/*
 * Copyright (c) MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.tooling.client.api.dataweave.validation;

public class DataWeaveValidationError {

  private final int startIndex;
  private final int startLine;
  private final int endIndex;
  private final int endLine;
  private final String message;

  private DataWeaveValidationError(final int startIndex, final int startLine, final int endIndex, final int endLine,
                                   final String message) {
    this.startIndex = startIndex;
    this.startLine = startLine;
    this.endIndex = endIndex;
    this.endLine = endLine;
    this.message = message;
  }

  public String getMessage() {
    return message;
  }

  public int getEndLine() {
    return endLine;
  }

  public int getEndIndex() {
    return endIndex;
  }

  public int getStartLine() {
    return startLine;
  }

  public int getStartIndex() {
    return startIndex;
  }

  // ***********************************************************************************
  // ============== Builder class =================
  // ***********************************************************************************

  public static Builder builder() {
    return new Builder();
  }

  public static class Builder {

    private String message;
    private int startIndex;
    private int startLine;
    private int endIndex;
    private int endLine;

    private Builder() {
      // private, use static method
    }

    public DataWeaveValidationError build() {
      return new DataWeaveValidationError(startIndex, startLine, endIndex, endLine, message);
    }

    public Builder withMessage(final String message) {
      this.message = message;
      return this;
    }

    public Builder withStartIndex(final int startIndex) {
      this.startIndex = startIndex;
      return this;
    }

    public Builder withStartLine(final int startLine) {
      this.startLine = startLine;
      return this;
    }

    public Builder withEndIndex(final int endIndex) {
      this.endIndex = endIndex;
      return this;
    }

    public Builder withEndLine(final int endLine) {
      this.endLine = endLine;
      return this;
    }
  }

}
