/*
 * Copyright (c) MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.tooling.client.api.dataweave.validation;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public class DataWeaveValidationResponse {

  private final List<DataWeaveValidationError> errors;

  private DataWeaveValidationResponse(final List<DataWeaveValidationError> errors) {
    this.errors = errors;
  }

  public List<DataWeaveValidationError> getErrors() {
    return errors;
  }

  // ***********************************************************************************
  // ============== Builder class =================
  // ***********************************************************************************

  public static Builder builder() {
    return new Builder();
  }

  public static class Builder {

    private List<DataWeaveValidationError> errors = Collections.emptyList();
    private Exception exception;

    private Builder() {
      // private constructor
    }

    public DataWeaveValidationResponse build() {
      return new DataWeaveValidationResponse(computeErrors());
    }

    private List<DataWeaveValidationError> computeErrors() {
      return errors.isEmpty() && isError() //
          ? Arrays
              .<DataWeaveValidationError>asList(DataWeaveValidationError.builder().withMessage(exception.getMessage()).build()) //
          : errors;
    }

    private boolean isError() {
      return exception != null || !errors.isEmpty();
    }

    public Builder withException(final Exception exception) {
      this.exception = exception;
      return this;
    }

    public Builder withErrors(final List<DataWeaveValidationError> errors) {
      this.errors = errors;
      return this;
    }

  }
}
