/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.client.bootstrap;

import com.google.common.io.Files;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.ServiceLoader;
import java.util.stream.Collectors;
import org.apache.commons.lang3.ArrayUtils;
import org.mule.maven.client.api.MavenClient;
import org.mule.maven.client.api.MavenClientProvider;
import org.mule.maven.client.api.model.BundleDependency;
import org.mule.maven.client.api.model.BundleDescriptor;
import org.mule.maven.client.api.model.MavenConfiguration;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.api.meta.MuleVersion;
import org.mule.tooling.client.api.AbstractToolingRuntimeClientBuilderFactory;
import org.mule.tooling.client.api.Disposable;
import org.mule.tooling.client.api.ToolingRuntimeClient;
import org.mule.tooling.client.api.descriptors.ArtifactDescriptor;
import org.mule.tooling.client.api.exception.ToolingException;
import org.mule.tooling.client.bootstrap.ExtendedBuilder;
import org.mule.tooling.client.bootstrap.ExtendedToolingURLClassLoader;
import org.mule.tooling.client.bootstrap.internal.VersionResolver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ToolingRuntimeClientBootstrap
implements Disposable {
    private static final String ORG_MULE_TOOLING = "org.mule.tooling";
    private static final String MULE_RUNTIME_TOOLING_CLIENT = "mule-runtime-tooling-client";
    private static final String SUFFIX_VERSION = "-0.9.x";
    private static final String SNAPSHOT = "-SNAPSHOT";
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final MavenClient mavenClient;
    private URLClassLoader extendedClassLoader;
    private AbstractToolingRuntimeClientBuilderFactory toolingRuntimeClientBuilderFactory;

    public ToolingRuntimeClientBootstrap(String muleVersion, MavenConfiguration mavenConfiguration) {
        Objects.requireNonNull(muleVersion, "muleVersion cannot be null");
        String versionWithSuffix = this.getVersionWithSuffix(muleVersion);
        this.logger.info("Creating loader for muleVersion: {}, requested version was: {}", (Object)versionWithSuffix, (Object)muleVersion);
        this.mavenClient = MavenClientProvider.discoverProvider((ClassLoader)ToolingRuntimeClientBootstrap.class.getClassLoader()).createMavenClient(mavenConfiguration);
        this.extendedClassLoader = this.createClassLoader(versionWithSuffix);
        this.toolingRuntimeClientBuilderFactory = this.discoverToolingRuntimeClientFactory();
    }

    private String getVersionWithSuffix(String muleVersion) {
        MuleVersion version = new MuleVersion(muleVersion);
        version.setMinor(0);
        version.setRevision(0);
        String modifiedMuleVersion = version.toString();
        if (modifiedMuleVersion.endsWith(SNAPSHOT)) {
            return modifiedMuleVersion.replace(SNAPSHOT, "-0.9.x-SNAPSHOT");
        }
        return modifiedMuleVersion + SUFFIX_VERSION;
    }

    private AbstractToolingRuntimeClientBuilderFactory discoverToolingRuntimeClientFactory() {
        ServiceLoader<AbstractToolingRuntimeClientBuilderFactory> serviceLoader = ServiceLoader.load(AbstractToolingRuntimeClientBuilderFactory.class, this.extendedClassLoader);
        if (!serviceLoader.iterator().hasNext()) {
            throw new IllegalStateException("No service found for: '" + AbstractToolingRuntimeClientBuilderFactory.class.getName() + "'");
        }
        return serviceLoader.iterator().next();
    }

    private URLClassLoader createClassLoader(String muleVersion) {
        try {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Creating URL class loader for muleVersion: {}", (Object)muleVersion);
            }
            String toolingVersion = VersionResolver.mapToolingVersion(this.getClass().getClassLoader(), muleVersion);
            LinkedHashSet<File> classpath = new LinkedHashSet<File>();
            classpath.addAll(this.resolveDependency(ArtifactDescriptor.newBuilder().withGroupId(ORG_MULE_TOOLING).withArtifactId(MULE_RUNTIME_TOOLING_CLIENT).withVersion(toolingVersion).build()));
            BundleDependency bundleDependency = this.mavenClient.resolveBundleDescriptor(new BundleDescriptor.Builder().setGroupId(ORG_MULE_TOOLING).setArtifactId(MULE_RUNTIME_TOOLING_CLIENT).setVersion(toolingVersion).setType("jar").build());
            Object[] urls = new URL[]{};
            urls = (URL[])ArrayUtils.addAll((Object[])urls, (Object[])new URL[]{this.getBundleUrl(bundleDependency)});
            urls = (URL[])ArrayUtils.addAll((Object[])urls, (Object[])classpath.stream().filter(file -> Files.getFileExtension((String)file.getAbsolutePath()).equals("jar")).map(file -> ToolingRuntimeClientBootstrap.toUrl(file)).toArray(URL[]::new));
            ExtendedToolingURLClassLoader classLoader = new ExtendedToolingURLClassLoader((URL[])urls, this.getClass().getClassLoader());
            if (this.logger.isTraceEnabled()) {
                this.logger.trace("Created extended URL class loader: {}", classpath);
            }
            return classLoader;
        }
        catch (Exception e) {
            throw new ToolingException("Couldn't create the class loader for the tooling client", (Throwable)e);
        }
    }

    private URL getBundleUrl(BundleDependency bundleDependency) {
        try {
            return bundleDependency.getBundleUri().toURL();
        }
        catch (MalformedURLException e) {
            throw new MuleRuntimeException((Throwable)e);
        }
    }

    private List<File> resolveDependency(ArtifactDescriptor artifactDescriptor) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Resolving Tooling Runtime Client implementation libraries from: {}", (Object)artifactDescriptor);
        }
        List bundleDependencies = this.mavenClient.resolveBundleDescriptorDependencies(false, true, new BundleDescriptor.Builder().setGroupId(artifactDescriptor.getGroupId()).setArtifactId(artifactDescriptor.getArtifactId()).setVersion(artifactDescriptor.getVersion()).setType(artifactDescriptor.getExtension()).setClassifier(artifactDescriptor.getClassifier()).build());
        return bundleDependencies.stream().filter(bundleDependency -> bundleDependency.getBundleUri() != null).map(bundleDependency -> new File(this.getBundleUrl((BundleDependency)bundleDependency).getFile())).collect(Collectors.toList());
    }

    private static URL toUrl(File file) {
        try {
            return file.toURI().toURL();
        }
        catch (MalformedURLException e) {
            throw new ToolingException("Couldn't get URL for file: " + file, (Throwable)e);
        }
    }

    public ToolingRuntimeClient.Builder newToolingRuntimeClientBuilder() {
        if (this.extendedClassLoader == null) {
            throw new IllegalStateException("Cannot be created a ToolingRuntimeClient builder once the bootstrap has been disposed");
        }
        ClassLoader currentContextClassLoader = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(this.extendedClassLoader);
            ExtendedBuilder extendedBuilder = new ExtendedBuilder(this.toolingRuntimeClientBuilderFactory.create(this.mavenClient), this.extendedClassLoader);
            return extendedBuilder;
        }
        catch (Exception e) {
            throw new ToolingException("Error while instantiating DefaultToolingRuntimeClient class", (Throwable)e);
        }
        finally {
            Thread.currentThread().setContextClassLoader(currentContextClassLoader);
        }
    }

    public void dispose() {
        try {
            this.toolingRuntimeClientBuilderFactory.dispose();
        }
        finally {
            this.toolingRuntimeClientBuilderFactory = null;
        }
        try {
            this.extendedClassLoader.close();
        }
        catch (IOException e) {
            throw new ToolingException("Error while closing extended class loader", (Throwable)e);
        }
        finally {
            this.extendedClassLoader = null;
        }
    }
}

