/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.client.bootstrap;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExtendedToolingURLClassLoader
extends URLClassLoader {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private ClassLoader system = ExtendedToolingURLClassLoader.getSystemClassLoader();

    public ExtendedToolingURLClassLoader(URL[] classpath, ClassLoader parent) {
        super(classpath, parent);
        if (this.logger.isTraceEnabled()) {
            this.logger.trace("SystemClassLoader is {}", (Object)this.system);
        }
    }

    @Override
    protected synchronized Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
        Class<?> clazz;
        block10: {
            clazz = this.findLoadedClass(name);
            if (clazz == null) {
                if (this.system != null) {
                    try {
                        clazz = this.system.loadClass(name);
                        if (this.logger.isTraceEnabled()) {
                            this.logClassLoaded(name, this.system);
                        }
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        // empty catch block
                    }
                }
                if (clazz == null) {
                    try {
                        clazz = this.findClass(name);
                        if (this.logger.isTraceEnabled()) {
                            this.logClassLoaded(name, this);
                        }
                    }
                    catch (ClassNotFoundException e) {
                        clazz = super.loadClass(name, resolve);
                        if (!this.logger.isTraceEnabled()) break block10;
                        this.logClassLoaded(name, this.getParent());
                    }
                }
            }
        }
        if (resolve) {
            this.resolveClass(clazz);
        }
        return clazz;
    }

    private void logClassLoaded(String className, ClassLoader classLoader) {
        this.logger.trace("Class '{}' loaded with {}", (Object)className, (Object)classLoader);
    }

    @Override
    public URL getResource(String name) {
        URL url = null;
        if (this.system != null) {
            url = this.system.getResource(name);
        }
        if (url == null && (url = this.findResource(name)) == null) {
            url = super.getResource(name);
        }
        return url;
    }

    @Override
    public Enumeration<URL> getResources(String name) throws IOException {
        Enumeration<URL> systemUrls = null;
        if (this.system != null) {
            systemUrls = this.system.getResources(name);
        }
        Enumeration<URL> localUrls = this.findResources(name);
        Enumeration<URL> parentUrls = null;
        if (this.getParent() != null && this.getParent() != this.system) {
            parentUrls = this.getParent().getResources(name);
        }
        final ArrayList<URL> urls = new ArrayList<URL>();
        if (systemUrls != null) {
            while (systemUrls.hasMoreElements()) {
                urls.add(systemUrls.nextElement());
            }
        }
        if (localUrls != null) {
            while (localUrls.hasMoreElements()) {
                urls.add(localUrls.nextElement());
            }
        }
        if (parentUrls != null) {
            while (parentUrls.hasMoreElements()) {
                urls.add(parentUrls.nextElement());
            }
        }
        return new Enumeration<URL>(){
            Iterator<URL> iter;
            {
                this.iter = urls.iterator();
            }

            @Override
            public boolean hasMoreElements() {
                return this.iter.hasNext();
            }

            @Override
            public URL nextElement() {
                return this.iter.next();
            }
        };
    }

    @Override
    public InputStream getResourceAsStream(String name) {
        URL url = this.getResource(name);
        try {
            return url != null ? url.openStream() : null;
        }
        catch (IOException iOException) {
            return null;
        }
    }
}

