/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.client.bootstrap.internal;

import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.mule.tooling.client.api.exception.ToolingException;

public class VersionResolver {
    public static final String TOOLING_VERSION_MAPPING_FILE = "mule-tooling-version.properties";
    public static final String TOOLING_VERSION_PROPERTY = "mule.tolling.version";
    public static final String TOOLING_VERSION_PROPERTY_SEPARATOR = ",";
    public static final String TOOLING_VERSION_PROPERTY_MAPPING_SEPARATOR = ":";

    private static Map<String, String> getToolingMappings(String property) {
        HashMap<String, String> map = new HashMap<String, String>();
        if (property == null) {
            return map;
        }
        for (String version : property.split(TOOLING_VERSION_PROPERTY_SEPARATOR)) {
            String[] sep = version.split(TOOLING_VERSION_PROPERTY_MAPPING_SEPARATOR);
            String muleVersion = sep[0];
            String mapedToolingVersion = sep[1];
            map.put(muleVersion, mapedToolingVersion);
        }
        return map;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String mapToolingVersion(ClassLoader classLoader, String runtimeVersion) {
        Map<String, String> toolingMappings = VersionResolver.getToolingMappings(System.getProperty(TOOLING_VERSION_PROPERTY));
        if (toolingMappings.containsKey(runtimeVersion)) {
            return toolingMappings.get(runtimeVersion);
        }
        Properties p = new Properties();
        try (InputStream is = classLoader.getResourceAsStream(TOOLING_VERSION_MAPPING_FILE);){
            if (is == null) {
                String string = runtimeVersion;
                return string;
            }
            p.load(is);
            String result = (String)p.get(runtimeVersion);
            if (result != null) {
                String string = result;
                return string;
            }
            String string = runtimeVersion;
            return string;
        }
        catch (IOException e) {
            throw new ToolingException("Error while reading file mule-tooling-version.properties", (Throwable)e);
        }
    }
}

