/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.client.bootstrap;

import java.io.InputStream;
import java.net.URLClassLoader;
import java.util.Objects;
import org.mule.maven.client.api.model.MavenConfiguration;
import org.mule.tooling.client.api.ToolingRuntimeClient;
import org.mule.tooling.client.api.configuration.agent.AgentConfiguration;

class ExtendedBuilder
implements ToolingRuntimeClient.Builder {
    private ToolingRuntimeClient.Builder delegate;
    private URLClassLoader extendedClassLoader;

    ExtendedBuilder(ToolingRuntimeClient.Builder builder, URLClassLoader extendedClassLoader) {
        Objects.requireNonNull(builder, "builder cannot be null");
        Objects.requireNonNull(extendedClassLoader, "extendedClassLoader cannot be null");
        if (builder.getClass().getClassLoader() != extendedClassLoader) {
            throw new IllegalStateException("Builder should be created with the same extended class loader");
        }
        this.delegate = builder;
        this.extendedClassLoader = extendedClassLoader;
    }

    public ToolingRuntimeClient.Builder withRemoteAgentConfiguration(AgentConfiguration agentConfiguration) {
        this.delegate.withRemoteAgentConfiguration(agentConfiguration);
        return this;
    }

    public ToolingRuntimeClient.Builder withMavenConfiguration(MavenConfiguration mavenConfiguration) {
        this.delegate.withMavenConfiguration(mavenConfiguration);
        return this;
    }

    public ToolingRuntimeClient.Builder withLoggingConfiguration(InputStream input) {
        this.delegate.withLoggingConfiguration(input);
        return this;
    }

    public ToolingRuntimeClient build() {
        ClassLoader currentContextClassLoader = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(this.extendedClassLoader);
            ToolingRuntimeClient toolingRuntimeClient = this.delegate.build();
            return toolingRuntimeClient;
        }
        finally {
            Thread.currentThread().setContextClassLoader(currentContextClassLoader);
        }
    }
}

