/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.mule.runtime.gw.policies.encryption.encrypter;

import com.mulesoft.mule.runtime.gw.internal.encryption.RuntimeEncrypter;
import com.mulesoft.mule.runtime.gw.model.PolicyProperty;
import com.mulesoft.mule.runtime.gw.policies.encryption.EncryptedValueResult;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringEscapeUtils;

public abstract class PolicyTypeEncrypter<T> {
    protected static final String TEMPLATE_PREFIX = "${secure::";
    protected static final String TEMPLATE_SUFFIX = "}";
    private final RuntimeEncrypter runtimeEncrypter;
    private final boolean isSensitiveOnlyEnabled;
    private final Map<String, PolicyProperty> policyProperties;

    public PolicyTypeEncrypter(RuntimeEncrypter runtimeEncrypter, boolean isSensitiveOnlyEnabled, List<PolicyProperty> policyProperties) {
        this.runtimeEncrypter = runtimeEncrypter;
        this.isSensitiveOnlyEnabled = isSensitiveOnlyEnabled;
        this.policyProperties = policyProperties.stream().collect(Collectors.toMap(PolicyProperty::getPropertyName, policyProperty -> policyProperty));
    }

    public boolean supports(String key) {
        return this.supports(key, this.findProperty(key));
    }

    public EncryptedValueResult encrypt(String key, T value) {
        Optional<PolicyProperty> policyProperty = this.findProperty(key);
        if (this.isSensitiveOnlyEnabled && policyProperty.isPresent() && !policyProperty.get().isSensitive()) {
            return this.decryptSingle(key, value);
        }
        return this.encryptSingle(key, value);
    }

    protected abstract EncryptedValueResult encryptSingle(String var1, T var2);

    protected abstract EncryptedValueResult decryptSingle(String var1, T var2);

    protected abstract boolean supports(String var1, Optional<PolicyProperty> var2);

    protected String encrypt(String value) {
        return this.runtimeEncrypter.encrypt(StringEscapeUtils.unescapeXml((String)value));
    }

    protected String decrypt(String value) {
        return StringEscapeUtils.unescapeXml((String)this.runtimeEncrypter.decrypt(value));
    }

    private Optional<PolicyProperty> findProperty(String key) {
        return Optional.ofNullable(this.policyProperties.get(key));
    }
}

