/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.mule.runtime.gw.policies.service.detection;

import com.mulesoft.mule.runtime.gw.model.PolicyDefinition;
import com.mulesoft.mule.runtime.gw.policies.PolicyDeploymentStatus;
import com.mulesoft.mule.runtime.gw.policies.service.MultiplexingPolicyDeploymentService;
import com.mulesoft.mule.runtime.gw.policies.service.detection.PolicySetChangeInspector;
import com.mulesoft.mule.runtime.gw.policies.service.detection.change.ChangeTypeVisitor;
import com.mulesoft.mule.runtime.gw.policies.service.detection.change.PolicyAdded;
import com.mulesoft.mule.runtime.gw.policies.service.detection.change.PolicyRemoved;
import com.mulesoft.mule.runtime.gw.policies.service.detection.change.PolicyReorder;
import com.mulesoft.mule.runtime.gw.policies.service.detection.change.PolicyRevert;
import com.mulesoft.mule.runtime.gw.policies.service.detection.change.PolicyUnmodified;
import com.mulesoft.mule.runtime.gw.policies.service.detection.change.PolicyUpdate;
import java.util.List;

public class PolicyChangeProcessor
implements ChangeTypeVisitor {
    private final PolicySetChangeInspector inspector = new PolicySetChangeInspector();
    private final MultiplexingPolicyDeploymentService policyDeploymentService;

    public PolicyChangeProcessor(MultiplexingPolicyDeploymentService policyDeploymentService) {
        this.policyDeploymentService = policyDeploymentService;
    }

    public void process(List<PolicyDeploymentStatus> currentStatusList, List<PolicyDefinition> newDefinitions) {
        this.inspector.detectChanges(currentStatusList, newDefinitions).forEach(change -> change.accept(this));
    }

    @Override
    public void visit(PolicyAdded policyAdded) {
        this.policyDeploymentService.newPolicy(policyAdded.getDefinition());
    }

    @Override
    public void visit(PolicyUpdate policyUpdate) {
        this.policyDeploymentService.updatePolicy(policyUpdate.getAppliedDefinition(), policyUpdate.getDefinition());
    }

    @Override
    public void visit(PolicyRemoved policyRemoved) {
        this.policyDeploymentService.removePolicy(policyRemoved.getDefinition());
    }

    @Override
    public void visit(PolicyReorder policyReorder) {
        this.policyDeploymentService.reorderPolicy(policyReorder.getAppliedDefinition(), policyReorder.getDefinition());
    }

    @Override
    public void visit(PolicyRevert policyRevert) {
        this.policyDeploymentService.revertPolicy(policyRevert.getDefinition());
    }

    @Override
    public void visit(PolicyUnmodified policyUnmodified) {
    }
}

