/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.internal.connection;

import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Consumer;
import org.mule.runtime.api.connection.ConnectionException;
import org.mule.runtime.api.connection.ConnectionProvider;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.core.internal.connection.ConnectionHandlerAdapter;
import org.mule.runtime.extension.api.connectivity.XATransactionalConnection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class CachedConnectionHandler<C>
implements ConnectionHandlerAdapter<C> {
    private static final Logger LOGGER = LoggerFactory.getLogger(CachedConnectionHandler.class);
    private final Consumer<ConnectionHandlerAdapter<C>> releaser;
    private final ConnectionProvider<C> connectionProvider;
    private final AtomicBoolean closed = new AtomicBoolean(false);
    private final AtomicBoolean invalidated = new AtomicBoolean(false);
    private C connection;

    public CachedConnectionHandler(C connection, Consumer<ConnectionHandlerAdapter<C>> releaser, ConnectionProvider<C> connectionProvider) {
        this.connection = connection;
        this.releaser = releaser;
        this.connectionProvider = connectionProvider;
    }

    public C getConnection() throws ConnectionException {
        return this.connection;
    }

    public void release() {
        C c = this.connection;
        if (c instanceof XATransactionalConnection) {
            XATransactionalConnection xaTxConnection = (XATransactionalConnection)c;
            xaTxConnection.close();
        }
    }

    @Override
    public void close() throws MuleException {
        if (!this.closed.compareAndSet(false, true)) {
            return;
        }
        try {
            this.connectionProvider.disconnect(this.connection);
        }
        catch (Exception e) {
            if (LOGGER.isWarnEnabled()) {
                LOGGER.warn(String.format("Error disconnecting cached connection %s. %s", this.connection, e.getMessage()), (Throwable)e);
            }
        }
        finally {
            this.connection = null;
        }
    }

    public void invalidate() {
        if (this.invalidated.compareAndSet(false, true)) {
            try {
                this.close();
            }
            catch (Exception e) {
                if (LOGGER.isWarnEnabled()) {
                    LOGGER.warn(String.format("Error invalidating cached connection %s. %s", this.connection, e.getMessage()), (Throwable)e);
                }
            }
            finally {
                this.releaser.accept(this);
            }
        }
    }

    @Override
    public ConnectionProvider<C> getConnectionProvider() {
        return this.connectionProvider;
    }
}

