/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.mule.runtime.module.license.internal;

import com.mulesoft.mule.runtime.module.license.internal.EeLicenseValidatorUtils;
import java.util.ArrayList;
import java.util.List;
import org.mule.runtime.module.license.api.LicenseValidator;
import org.mule.runtime.module.license.api.PluginLicenseValidationRequest;
import org.mule.runtime.module.license.api.exception.InvalidLicenseException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AtLeastOneValidatorSucceedsLicenseValidator
implements LicenseValidator {
    private static final Logger LOGGER = LoggerFactory.getLogger(AtLeastOneValidatorSucceedsLicenseValidator.class);

    public void validatePluginLicense(PluginLicenseValidationRequest pluginLicenseValidationRequest) {
        List<LicenseValidator> validators = this.getLicenseValidators();
        ArrayList<Throwable> exceptions = new ArrayList<Throwable>();
        if (validators == null || validators.isEmpty()) {
            throw new ValidationException("No validators found");
        }
        boolean validated = false;
        for (LicenseValidator validator : validators) {
            try {
                validator.validatePluginLicense(pluginLicenseValidationRequest);
                validated = true;
            }
            catch (Throwable e) {
                exceptions.add(e);
                LOGGER.debug("Error using validator of class: " + String.valueOf(validator.getClass()));
            }
            if (!validated) continue;
            break;
        }
        if (!validated) {
            throw new InvalidLicenseException(EeLicenseValidatorUtils.getFormattedExceptions(exceptions));
        }
    }

    abstract List<LicenseValidator> getLicenseValidators();

    static class ValidationException
    extends RuntimeException {
        public ValidationException(String message) {
            super(message);
        }
    }
}

