/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.mule.runtime.module.serialization.kryo.internal.mapper;

import com.mulesoft.mule.runtime.module.serialization.kryo.internal.mapper.SerializationMapper;
import java.io.Serializable;
import java.sql.Timestamp;

public class DefaultSerializationMapper
implements SerializationMapper {
    @Override
    public Object mapBeforeSerialization(Object original) {
        if (original == null) {
            return null;
        }
        if (original instanceof Timestamp) {
            return new TimestampWrapper((Timestamp)original);
        }
        return original;
    }

    @Override
    public Object mapAfterDeserialization(Object deserialized) {
        if (deserialized == null) {
            return null;
        }
        if (deserialized instanceof TimestampWrapper) {
            return ((TimestampWrapper)deserialized).createTimestamp();
        }
        return deserialized;
    }

    private static class TimestampWrapper
    implements Serializable {
        private static final long serialVersionUID = -3884610299010517720L;
        private long millis;
        private int nanos;

        public TimestampWrapper(Timestamp timestamp) {
            this.millis = TimestampWrapper.millisecondsComponent(timestamp);
            this.nanos = timestamp.getNanos();
        }

        private static long millisecondsComponent(Timestamp timestamp) {
            return timestamp.getTime() - (long)(timestamp.getNanos() / 1000000);
        }

        public Timestamp createTimestamp() {
            Timestamp t = new Timestamp(this.millis);
            t.setNanos(this.nanos);
            return t;
        }
    }
}

