/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.mule.runtime.module.reboot.license;

import com.mulesoft.mule.runtime.module.boot.license.LicenseKey;
import com.mulesoft.mule.runtime.module.boot.license.interrupt.TestingModeInterrupter;
import com.mulesoft.mule.runtime.module.reboot.license.LicenseBootstrapConfigurer;
import com.mulesoft.mule.runtime.module.reboot.license.LicenseException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import org.mule.runtime.module.boot.internal.BootstrapConfigurationException;
import org.slf4j.Logger;

public class LicenseCheckBootstrapConfigurer
extends LicenseBootstrapConfigurer {
    private final CompletableFuture<LicenseKey> licenseValidation = new CompletableFuture();
    private final boolean async;
    private volatile boolean disposeRequested = false;

    public LicenseCheckBootstrapConfigurer(Logger bootstrapLogger, boolean async) {
        super(bootstrapLogger);
        this.async = async;
    }

    @Override
    public boolean configure() throws BootstrapConfigurationException {
        try {
            return this.doConfigure();
        }
        catch (RuntimeException e) {
            if (e.getCause() != null) {
                throw new BootstrapConfigurationException(1, e.getCause());
            }
            throw new BootstrapConfigurationException(1, (Throwable)e);
        }
        catch (LicenseException e) {
            throw new BootstrapConfigurationException(1, e.getCause());
        }
        catch (Exception e) {
            throw new BootstrapConfigurationException(1, (Throwable)e);
        }
    }

    @Override
    protected boolean doConfigure() throws LicenseException {
        this.validateLicense();
        return true;
    }

    private void validateLicense() throws LicenseException {
        if (this.async) {
            new Thread(() -> {
                try {
                    this.licenseValidation.complete(this.doValidateLicense());
                }
                catch (Exception e) {
                    this.licenseValidation.completeExceptionally(e);
                }
            }).start();
        } else {
            this.doValidateLicense();
        }
    }

    private LicenseKey doValidateLicense() throws LicenseException {
        LicenseKey key = this.createLicenseKeyHandler().validate();
        if (key == null) {
            throw new LicenseException("No key returned.");
        }
        if (key.isEvaluationLicense()) {
            this.moveLicenseKeyFileToMuleBaseConf(this.lookupMuleBaseConf());
        }
        this.logLicenseInfo(key);
        return key;
    }

    private void logLicenseInfo(LicenseKey key) {
        if (TestingModeInterrupter.getInterrupter().isInterruptionScheduled()) {
            this.getBootstrapLogger().info("Running Mule in testing mode");
        } else {
            this.getBootstrapLogger().info(String.format("Valid license key --> %s", key));
        }
    }

    public void await() throws BootstrapConfigurationException {
        if (TestingModeInterrupter.isTestingMode()) {
            return;
        }
        if (!this.disposeRequested) {
            try {
                this.licenseValidation.get();
                return;
            }
            catch (ExecutionException e) {
                throw new BootstrapConfigurationException(1, e.getCause());
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new BootstrapConfigurationException(1, (Throwable)e);
            }
        }
    }

    public void dispose() {
        this.disposeRequested = true;
        this.licenseValidation.cancel(true);
        TestingModeInterrupter.getInterrupter().dispose();
    }
}

