/*
 * Decompiled with CFR 0.152.
 */
package org.mule.framework.internal.builder.application;

import com.google.common.collect.ImmutableList;
import java.net.URL;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import org.mule.framework.api.MuleFramework;
import org.mule.framework.api.builder.ConfigurationsCreationConfigurer;
import org.mule.framework.api.builder.FrameworkApplicationConfigurer;
import org.mule.framework.internal.DietMuleFrameworkStaticAnalysis;
import org.mule.framework.internal.InternalMuleFramework;
import org.mule.framework.internal.builder.application.DefaultFrameworkApplication;
import org.mule.framework.internal.builder.application.FrameworkApplication;
import org.mule.framework.internal.builder.application.InternalFrameworkApplicationConfigurer;
import org.mule.framework.internal.builder.configurations.DefaultConfigurationsCreationConfigurer;
import org.mule.framework.internal.builder.configurations.InternalConfigurationsCreationConfigurer;
import org.mule.framework.internal.builder.domain.FrameworkDomain;
import org.mule.runtime.module.artifact.activation.api.classloader.ArtifactClassLoaderResolver;
import org.mule.runtime.module.artifact.activation.api.descriptor.DeployableArtifactDescriptorCreator;
import org.mule.runtime.module.artifact.activation.api.descriptor.DomainDescriptorResolutionException;
import org.mule.runtime.module.artifact.activation.api.descriptor.DomainDescriptorResolver;
import org.mule.runtime.module.artifact.activation.api.plugin.PluginClassLoaderResolver;
import org.mule.runtime.module.artifact.api.classloader.MuleDeployableArtifactClassLoader;
import org.mule.runtime.module.artifact.api.descriptor.ApplicationDescriptor;
import org.mule.runtime.module.artifact.api.descriptor.BundleDescriptor;
import org.mule.runtime.module.artifact.api.descriptor.DomainDescriptor;

public abstract class AbstractFrameworkApplicationConfigurer
implements InternalFrameworkApplicationConfigurer {
    private static final PluginClassLoaderResolver DEFAULT_PLUGIN_CLASSLOADER_RESOLVER = (ownerClassLoader, artifactPluginDescriptor) -> Optional.empty();
    private DomainDescriptorResolver domainDescriptorResolver = DomainDescriptorResolver.noDomainDescriptorResolver();
    private ApplicationDescriptor applicationDescriptor;
    private InternalConfigurationsCreationConfigurer configsCreationConfigurer;
    private PluginClassLoaderResolver pluginClassLoaderResolver = DEFAULT_PLUGIN_CLASSLOADER_RESOLVER;
    private boolean dslValidations = true;

    public FrameworkApplicationConfigurer withConfigurations() {
        if (this.configsCreationConfigurer != null) {
            throw new IllegalStateException("Configurations creation has already been configured");
        }
        this.configsCreationConfigurer = new DefaultConfigurationsCreationConfigurer();
        return this;
    }

    public FrameworkApplicationConfigurer withConfigurations(Consumer<ConfigurationsCreationConfigurer> configurer) {
        if (this.configsCreationConfigurer != null) {
            throw new IllegalStateException("Configurations creation has already been configured");
        }
        this.configsCreationConfigurer = new DefaultConfigurationsCreationConfigurer();
        configurer.accept(this.configsCreationConfigurer);
        this.validateConfigurer(this.configsCreationConfigurer);
        return this;
    }

    public FrameworkApplicationConfigurer disableDslValidations() {
        this.dslValidations = false;
        return this;
    }

    protected void validateConfigurer(InternalConfigurationsCreationConfigurer configsCreationConfigurer) {
    }

    public FrameworkApplicationConfigurer withPluginClassLoaderResolver(PluginClassLoaderResolver pluginClassLoaderResolver) {
        if (pluginClassLoaderResolver == null) {
            throw new IllegalArgumentException("'pluginClassLoaderResolver' cannot be null");
        }
        if (this.pluginClassLoaderResolver != DEFAULT_PLUGIN_CLASSLOADER_RESOLVER) {
            throw new IllegalStateException("'pluginClassLoaderResolver' is already set");
        }
        this.pluginClassLoaderResolver = pluginClassLoaderResolver;
        return this;
    }

    public FrameworkApplicationConfigurer withDomain(Function<BundleDescriptor, MuleFramework> domainResolver) {
        if (domainResolver == null) {
            throw new IllegalArgumentException("'domainResolver' cannot be null");
        }
        if (this.domainDescriptorResolver != DomainDescriptorResolver.noDomainDescriptorResolver()) {
            throw new IllegalStateException("'domainResolver' is already set");
        }
        this.domainDescriptorResolver = new MuleFrameworkDomainDescriptorResolver(domainResolver);
        return this;
    }

    @Override
    public final Optional<InternalMuleFramework> getDomainFramework() {
        if (!this.domainDescriptorResolver.equals(DomainDescriptorResolver.noDomainDescriptorResolver())) {
            if (!this.appDependsOnDomain(this.applicationDescriptor) && this.getDomainFwk().isPresent()) {
                throw new IllegalStateException("'withDomain' resolved a domain, but application does not require one.");
            }
            if (this.appDependsOnDomain(this.applicationDescriptor) && !this.getDomainFwk().isPresent()) {
                throw new IllegalStateException("'withDomain' did not resolve a domain, but application requires one.");
            }
        }
        Optional<InternalMuleFramework> domainFwk = this.getDomainFwk().map(InternalMuleFramework.class::cast);
        domainFwk.filter(fwk -> !(fwk instanceof DietMuleFrameworkStaticAnalysis)).ifPresent(InternalMuleFramework::assertStarted);
        return domainFwk;
    }

    protected final boolean appDependsOnDomain(ApplicationDescriptor applicationDescriptor) {
        return applicationDescriptor.getDomainName() != null && !applicationDescriptor.getDomainName().equals("default") || applicationDescriptor.getDomainDescriptor().isPresent();
    }

    protected DomainDescriptorResolver getDomainDescriptorResolver() {
        return this.domainDescriptorResolver;
    }

    @Override
    public FrameworkApplication configure(ArtifactClassLoaderResolver classLoaderResolver, Map<String, String> deploymentProperties) {
        MuleDeployableArtifactClassLoader applicationClassLoader = this.createApplicationClassLoader(classLoaderResolver, deploymentProperties);
        return this.getFrameworkApplication(applicationClassLoader, this.configsCreationConfigurer, this.dslValidations);
    }

    protected DefaultFrameworkApplication getFrameworkApplication(MuleDeployableArtifactClassLoader applicationClassLoader, InternalConfigurationsCreationConfigurer configsCreationConfigurer, boolean dslValidations) {
        return new DefaultFrameworkApplication(applicationClassLoader, Optional.empty(), configsCreationConfigurer, this.getDomainFramework().map(dFwk -> (FrameworkDomain)dFwk.getFrameworkDeployableArtifact()), dslValidations);
    }

    private MuleDeployableArtifactClassLoader createApplicationClassLoader(ArtifactClassLoaderResolver classLoaderResolver, Map<String, String> deploymentProperties) {
        HashSet<URL> folderUrls = new HashSet<URL>();
        this.applicationDescriptor = this.createApplicationDescriptor(deploymentProperties, folderUrls);
        return classLoaderResolver.createApplicationClassLoader(this.applicationDescriptor, this.pluginClassLoaderResolver, (List)ImmutableList.copyOf(folderUrls));
    }

    protected abstract ApplicationDescriptor createApplicationDescriptor(Map<String, String> var1, Set<URL> var2);

    private Optional<MuleFramework> getDomainFwk() {
        if (this.domainDescriptorResolver instanceof MuleFrameworkDomainDescriptorResolver) {
            return Optional.ofNullable(((MuleFrameworkDomainDescriptorResolver)this.domainDescriptorResolver).getDomainFwk());
        }
        return Optional.empty();
    }

    private class MuleFrameworkDomainDescriptorResolver
    implements DomainDescriptorResolver {
        private final Function<BundleDescriptor, MuleFramework> domainMuleFrameworkResolver;
        private MuleFramework domainFwk;

        public MuleFrameworkDomainDescriptorResolver(Function<BundleDescriptor, MuleFramework> domainMuleFrameworkResolver) {
            this.domainMuleFrameworkResolver = domainMuleFrameworkResolver;
        }

        public DomainDescriptor resolve(String name, BundleDescriptor bundleDescriptor) throws DomainDescriptorResolutionException {
            if ((name == null || name.equals("default")) && bundleDescriptor == null) {
                return null;
            }
            this.domainFwk = this.domainMuleFrameworkResolver.apply(bundleDescriptor);
            DomainDescriptor domainDescriptor = (DomainDescriptor)DeployableArtifactDescriptorCreator.domainDescriptorCreator().create(name != null ? name : bundleDescriptor.getArtifactId());
            domainDescriptor.setBundleDescriptor(bundleDescriptor);
            return domainDescriptor;
        }

        public MuleFramework getDomainFwk() {
            return this.domainFwk;
        }
    }
}

