/*
 * Decompiled with CFR 0.152.
 */
package org.mule.framework.internal.builder.artifact;

import com.google.common.collect.Maps;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.Set;
import java.util.stream.Collectors;
import org.mule.framework.internal.builder.artifact.FrameworkDeployableArtifact;
import org.mule.framework.internal.builder.configurations.InternalConfigurationsCreationConfigurer;
import org.mule.runtime.api.component.TypedComponentIdentifier;
import org.mule.runtime.api.lifecycle.InitialisationException;
import org.mule.runtime.api.meta.model.ExtensionModel;
import org.mule.runtime.api.metadata.ExpressionLanguageMetadataService;
import org.mule.runtime.ast.api.ArtifactAst;
import org.mule.runtime.ast.api.ArtifactType;
import org.mule.runtime.ast.api.ComponentAst;
import org.mule.runtime.ast.api.xml.AstXmlParser;
import org.mule.runtime.config.api.properties.ConfigurationPropertiesHierarchyBuilder;
import org.mule.runtime.config.api.properties.ConfigurationPropertiesResolver;
import org.mule.runtime.config.api.properties.ConfigurationPropertiesResolverProvider;
import org.mule.runtime.config.internal.model.dsl.config.PropertiesResolverConfigurationProperties;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.config.ConfigurationException;
import org.mule.runtime.core.api.lifecycle.LifecycleUtils;
import org.mule.runtime.core.api.util.ClassUtils;
import org.mule.runtime.dsl.api.ConfigResource;
import org.mule.runtime.dsl.api.xml.parser.ParsingPropertyResolver;
import org.mule.runtime.module.artifact.activation.api.ast.ArtifactAstUtils;
import org.mule.runtime.module.artifact.activation.api.deployable.DeployableProjectModel;
import org.mule.runtime.module.artifact.api.classloader.MuleDeployableArtifactClassLoader;
import org.mule.runtime.module.artifact.api.descriptor.DeployableArtifactDescriptor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class DefaultFrameworkDeployableArtifact<AD extends DeployableArtifactDescriptor>
implements FrameworkDeployableArtifact {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultFrameworkDeployableArtifact.class);
    private final MuleDeployableArtifactClassLoader deployableArtifactClassLoader;
    private final Optional<DeployableProjectModel> deployableProjectModel;
    private final InternalConfigurationsCreationConfigurer configsCreationConfigurer;
    private final boolean dslValidations;
    private ArtifactAst artifactAst;
    private Collection<ComponentAst> configsAsts;
    private ConfigurationPropertiesResolverProvider configurationProperties;

    public DefaultFrameworkDeployableArtifact(MuleDeployableArtifactClassLoader deployableArtifactClassLoader, Optional<DeployableProjectModel> deployableProjectModel, InternalConfigurationsCreationConfigurer configsCreationConfigurer, boolean dslValidations) {
        this.deployableArtifactClassLoader = deployableArtifactClassLoader;
        this.deployableProjectModel = deployableProjectModel;
        this.configsCreationConfigurer = configsCreationConfigurer;
        this.dslValidations = dslValidations;
    }

    @Override
    public void setUp(Set<ExtensionModel> extensionModels) {
        this.artifactAst = this.createAst(extensionModels);
        this.configsAsts = this.getConfigsAsts(this.artifactAst);
    }

    protected final ArtifactAst createAst(Set<ExtensionModel> extensionModels) {
        if (this.configsCreationConfigurer != null && this.configsCreationConfigurer.getArtifactAst() != null) {
            return this.configsCreationConfigurer.getArtifactAst();
        }
        return (ArtifactAst)ClassUtils.withContextClassLoader((ClassLoader)this.deployableArtifactClassLoader, () -> this.loadAst(extensionModels));
    }

    @Override
    public void setUp(MuleContext muleContext, ExpressionLanguageMetadataService expressionLanguageMetadataService, Set<ExtensionModel> extensionModels) throws ConfigurationException, InitialisationException {
        if (this.artifactAst == null) {
            Map<String, String> deploymentProperties = this.getDeploymentPropertiesFromArtifact((DeployableArtifactDescriptor)this.deployableArtifactClassLoader.getArtifactDescriptor());
            ArtifactAst artifactAst = this.artifactAst = this.configsCreationConfigurer != null ? this.configsCreationConfigurer.getArtifactAst() : null;
            if (this.artifactAst == null) {
                this.artifactAst = this.createAst((DeployableArtifactDescriptor)this.deployableArtifactClassLoader.getArtifactDescriptor(), muleContext, expressionLanguageMetadataService, extensionModels, deploymentProperties);
            }
            if (this.configsCreationConfigurer != null) {
                this.configsCreationConfigurer.configure(this.artifactAst, muleContext.getExecutionClassLoader(), deploymentProperties);
                this.configurationProperties = this.configsCreationConfigurer.getConfigurationProperties();
            } else {
                this.configurationProperties = this.createSimpleConfigurationProperties(deploymentProperties);
            }
            if (this.artifactAst != null) {
                this.configsAsts = this.getConfigsAsts(this.artifactAst);
            }
        }
    }

    protected ArtifactAst loadAst(Set<ExtensionModel> extensionModels) {
        if (this.configsCreationConfigurer != null && this.configsCreationConfigurer.getArtifactAst() != null) {
            return this.configsCreationConfigurer.getArtifactAst();
        }
        AstXmlParser astXmlParser = this.doCreateMuleXmlParser(extensionModels, this.dslValidations, p -> p);
        Set configResources = ((DeployableArtifactDescriptor)this.deployableArtifactClassLoader.getArtifactDescriptor()).getConfigResources();
        return astXmlParser.parse((ConfigResource[])configResources.stream().map(configResource -> {
            try {
                return new ConfigResource(configResource, this.deployableArtifactClassLoader.getResource(configResource));
            }
            catch (IOException e) {
                throw new IllegalStateException(String.format("Cannot load config file '%s'.", configResource), e);
            }
        }).toArray(ConfigResource[]::new));
    }

    private AstXmlParser createMuleXmlParser(Set<ExtensionModel> extensions, Map<String, String> deploymentProperties, boolean disableXmlValidations) {
        ConfigurationPropertiesResolver propertyResolver = this.createSimpleConfigurationProperties(deploymentProperties).getConfigurationPropertiesResolver();
        return this.doCreateMuleXmlParser(extensions, disableXmlValidations, propertyKey -> (String)propertyResolver.resolveValue(propertyKey));
    }

    protected ArtifactAst createAst(AD artifactDescriptor, MuleContext muleContext, ExpressionLanguageMetadataService expressionLanguageMetadataService, Set<ExtensionModel> extensionModels, Map<String, String> deploymentProperties) throws ConfigurationException {
        return ArtifactAstUtils.parseAndBuildAppExtensionModel((String[])artifactDescriptor.getConfigResources().toArray(new String[artifactDescriptor.getConfigResources().size()]), (exts, disableValidations) -> this.createMuleXmlParser(exts, deploymentProperties, disableValidations), extensionModels, (ArtifactType)ArtifactType.APPLICATION, (!this.dslValidations ? 1 : 0) != 0, (MuleContext)muleContext, (ExpressionLanguageMetadataService)expressionLanguageMetadataService);
    }

    protected abstract AstXmlParser doCreateMuleXmlParser(Set<ExtensionModel> var1, boolean var2, ParsingPropertyResolver var3);

    private List<ComponentAst> getConfigsAsts(ArtifactAst artifactAst) {
        return artifactAst.topLevelComponentsStream().filter(tlc -> tlc.getComponentType().equals((Object)TypedComponentIdentifier.ComponentType.CONFIG)).collect(Collectors.toList());
    }

    protected PropertiesResolverConfigurationProperties createSimpleConfigurationProperties(Map<String, String> deploymentProperties) {
        return new PropertiesResolverConfigurationProperties(new ConfigurationPropertiesHierarchyBuilder().withDeploymentProperties(deploymentProperties).withoutFailuresIfPropertyNotPresent().build());
    }

    protected Map<String, String> getDeploymentPropertiesFromArtifact(AD artifactDescriptor) {
        return artifactDescriptor.getDeploymentProperties().map(dp -> Maps.fromProperties((Properties)dp)).orElse(Collections.emptyMap());
    }

    @Override
    public ConfigurationPropertiesResolverProvider getConfigurationProperties() {
        return this.configurationProperties;
    }

    @Override
    public boolean isCreateConfigurations() {
        return this.configsCreationConfigurer != null;
    }

    protected InternalConfigurationsCreationConfigurer getConfigsCreationConfigurer() {
        return this.configsCreationConfigurer;
    }

    @Override
    public Optional<DeployableProjectModel> getDeployableProjectModel() {
        return this.deployableProjectModel;
    }

    @Override
    public ArtifactAst getArtifactAst() {
        return this.artifactAst;
    }

    @Override
    public Optional<Collection<ComponentAst>> getConfigurationsAsts() {
        return Optional.ofNullable(this.configsAsts);
    }

    public void dispose() {
        LifecycleUtils.disposeIfNeeded((Object)this.configurationProperties, (Logger)LOGGER);
        this.deployableArtifactClassLoader.dispose();
    }
}

