/*
 * Decompiled with CFR 0.152.
 */
package org.mule.framework.internal.builder.domain;

import com.google.common.collect.ImmutableList;
import java.net.URL;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import org.mule.framework.api.builder.ConfigurationsCreationConfigurer;
import org.mule.framework.api.builder.FrameworkDomainConfigurer;
import org.mule.framework.internal.builder.configurations.DefaultConfigurationsCreationConfigurer;
import org.mule.framework.internal.builder.configurations.InternalConfigurationsCreationConfigurer;
import org.mule.framework.internal.builder.domain.DefaultFrameworkDomain;
import org.mule.framework.internal.builder.domain.FrameworkDomain;
import org.mule.framework.internal.builder.domain.InternalFrameworkDomainConfigurer;
import org.mule.runtime.module.artifact.activation.api.classloader.ArtifactClassLoaderResolver;
import org.mule.runtime.module.artifact.activation.api.plugin.PluginClassLoaderResolver;
import org.mule.runtime.module.artifact.api.classloader.MuleDeployableArtifactClassLoader;
import org.mule.runtime.module.artifact.api.descriptor.DomainDescriptor;

public abstract class AbstractFrameworkDomainConfigurer
implements InternalFrameworkDomainConfigurer {
    private static final PluginClassLoaderResolver DEFAULT_PLUGIN_CLASSLOADER_RESOLVER = (ownerClassLoader, artifactPluginDescriptor) -> Optional.empty();
    private InternalConfigurationsCreationConfigurer configsCreationConfigurer;
    private PluginClassLoaderResolver pluginClassLoaderResolver = DEFAULT_PLUGIN_CLASSLOADER_RESOLVER;
    private boolean dslValidations = true;

    public FrameworkDomainConfigurer withConfigurations() {
        if (this.configsCreationConfigurer != null) {
            throw new IllegalStateException("Configurations creation has already been configured");
        }
        this.configsCreationConfigurer = new DefaultConfigurationsCreationConfigurer();
        return this;
    }

    public FrameworkDomainConfigurer withConfigurations(Consumer<ConfigurationsCreationConfigurer> configurer) {
        if (this.configsCreationConfigurer != null) {
            throw new IllegalStateException("Configurations creation has already been configured");
        }
        this.configsCreationConfigurer = new DefaultConfigurationsCreationConfigurer();
        configurer.accept(this.configsCreationConfigurer);
        this.validateConfigurer(this.configsCreationConfigurer);
        return this;
    }

    public FrameworkDomainConfigurer disableDslValidations() {
        this.dslValidations = false;
        return this;
    }

    protected void validateConfigurer(InternalConfigurationsCreationConfigurer configsCreationConfigurer) {
    }

    public FrameworkDomainConfigurer withPluginClassLoaderResolver(PluginClassLoaderResolver pluginClassLoaderResolver) {
        if (pluginClassLoaderResolver == null) {
            throw new IllegalArgumentException("'pluginClassLoaderResolver' cannot be null");
        }
        if (this.pluginClassLoaderResolver != DEFAULT_PLUGIN_CLASSLOADER_RESOLVER) {
            throw new IllegalStateException("'pluginClassLoaderResolver' is already set");
        }
        this.pluginClassLoaderResolver = pluginClassLoaderResolver;
        return this;
    }

    @Override
    public FrameworkDomain configure(ArtifactClassLoaderResolver classLoaderResolver, Map<String, String> deploymentProperties) {
        MuleDeployableArtifactClassLoader domainClassLoader = this.createDomainClassLoader(classLoaderResolver, deploymentProperties);
        return this.getFrameworkDomain(domainClassLoader, this.configsCreationConfigurer, this.dslValidations);
    }

    protected DefaultFrameworkDomain getFrameworkDomain(MuleDeployableArtifactClassLoader domainClassLoader, InternalConfigurationsCreationConfigurer configsCreationConfigurer, boolean dslValidations) {
        return new DefaultFrameworkDomain(domainClassLoader, Optional.empty(), configsCreationConfigurer, dslValidations);
    }

    private MuleDeployableArtifactClassLoader createDomainClassLoader(ArtifactClassLoaderResolver classLoaderResolver, Map<String, String> deploymentProperties) {
        HashSet<URL> folderUrls = new HashSet<URL>();
        return classLoaderResolver.createDomainClassLoader(this.createDomainDescriptor(deploymentProperties, folderUrls), this.pluginClassLoaderResolver, (List)ImmutableList.copyOf(folderUrls));
    }

    protected abstract DomainDescriptor createDomainDescriptor(Map<String, String> var1, Set<URL> var2);
}

