/*
 * Decompiled with CFR 0.152.
 */
package org.mule.framework.internal.tooling;

import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.mule.framework.api.tooling.MuleToolingFramework;
import org.mule.framework.api.tooling.icon.IconsResult;
import org.mule.framework.api.tooling.sample.data.SampleDataSession;
import org.mule.framework.api.tooling.type.bindings.TypeBindingsResolutionSession;
import org.mule.framework.api.tooling.type.propagation.TypePropagationSession;
import org.mule.framework.api.tooling.type.resolution.TypeResolutionSession;
import org.mule.framework.api.tooling.value.ValueProviderSession;
import org.mule.framework.internal.InternalMuleFramework;
import org.mule.framework.internal.extension.config.InternalConfigurationHandler;
import org.mule.framework.internal.tooling.connectivity.ConnectivityTestCommand;
import org.mule.framework.internal.tooling.icon.IconSession;
import org.mule.framework.internal.tooling.sample.data.DietSampleDataSession;
import org.mule.framework.internal.tooling.type.bindings.DietBindingsResolutionSession;
import org.mule.framework.internal.tooling.type.propagation.cfg.CFGTypePropagationSession;
import org.mule.framework.internal.tooling.type.propagation.legacy.LegacyDataSenseSession;
import org.mule.framework.internal.tooling.type.resolution.DietTypeResolutionSession;
import org.mule.framework.internal.tooling.value.DietValueProviderSession;
import org.mule.runtime.api.component.TypedComponentIdentifier;
import org.mule.runtime.api.connection.ConnectionProvider;
import org.mule.runtime.api.connection.ConnectionValidationResult;
import org.mule.runtime.api.event.Event;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.api.meta.model.ComponentModel;
import org.mule.runtime.api.meta.model.ExtensionModel;
import org.mule.runtime.api.meta.model.connection.ConnectionProviderModel;
import org.mule.runtime.api.meta.model.parameter.ParameterizedModel;
import org.mule.runtime.api.metadata.MetadataStorage;
import org.mule.runtime.api.parameterization.ComponentParameterization;
import org.mule.runtime.ast.api.ArtifactAst;
import org.mule.runtime.core.api.event.CoreEvent;
import org.mule.runtime.core.api.util.ClassUtils;
import org.mule.runtime.metadata.api.cache.MetadataCacheId;
import org.mule.runtime.module.artifact.api.classloader.RegionClassLoader;

public class DietToolingFramework
implements MuleToolingFramework {
    public static final boolean USE_LEGACY_PROPAGATION = Boolean.getBoolean("mule.framework.use.legacy.propagation");
    private final InternalMuleFramework mule;
    private final ConnectivityTestCommand connectivityTestCommand = new ConnectivityTestCommand();
    private final IconSession iconSession;

    public DietToolingFramework(InternalMuleFramework mule) {
        this.mule = mule;
        this.iconSession = new IconSession(((RegionClassLoader)mule.getExecutionClassLoader()).getArtifactDescriptor().getClassLoaderConfiguration().getDependencies());
    }

    public ConnectionValidationResult testConnectivity(ExtensionModel extensionModel, ComponentParameterization<ConnectionProviderModel> parameterization) {
        this.mule.assertStarted();
        return (ConnectionValidationResult)ClassUtils.withContextClassLoader((ClassLoader)this.mule.getExecutionClassLoader(), () -> {
            try {
                return this.connectivityTestCommand.execute(extensionModel, parameterization, this.mule.getMuleContext(), this.mule.getReflectionCache());
            }
            catch (Exception e) {
                throw new MuleRuntimeException((Throwable)e);
            }
        });
    }

    public ConnectionValidationResult testConnectivity(String configName) {
        this.mule.assertStarted();
        InternalConfigurationHandler configurationHandler = (InternalConfigurationHandler)this.mule.getConfigurationHandler(configName).orElseThrow(() -> new IllegalArgumentException(String.format("No config with name '%s' is registered on this instance", configName)));
        ConnectionProvider connectionProvider = (ConnectionProvider)configurationHandler.getConfigurationProvider().get((Event)CoreEvent.nullEvent()).getConnectionProvider().orElseThrow(() -> new IllegalArgumentException(String.format("No connection provider has been registered for config '%s'", configName)));
        return (ConnectionValidationResult)ClassUtils.withContextClassLoader((ClassLoader)this.mule.getExecutionClassLoader(), () -> {
            try {
                return this.connectivityTestCommand.execute((ConnectionProvider<Object>)connectionProvider);
            }
            catch (Exception e) {
                throw new MuleRuntimeException((Throwable)e);
            }
        });
    }

    public TypeResolutionSession createTypeResolutionSession(String extensionName, ComponentModel componentModel) {
        return new DietTypeResolutionSession(this.mule, extensionName, componentModel);
    }

    public TypePropagationSession createTypePropagationSession(ArtifactAst application) {
        this.mule.assertStarted();
        List configsComonentAsts = application.topLevelComponentsStream().filter(potentialConfig -> potentialConfig.getComponentType().equals((Object)TypedComponentIdentifier.ComponentType.CONFIG)).collect(Collectors.toList());
        this.mule.getConfigIdGenerator().addConfigurations(configsComonentAsts);
        if (USE_LEGACY_PROPAGATION) {
            return new LegacyDataSenseSession(application, this.mule.getExecutionClassLoader(), this.mule.getExpressionLanguageMetadataService(), this.mule.getApiKitMetadataService(), this.mule);
        }
        return new CFGTypePropagationSession(this.mule, application);
    }

    public TypePropagationSession createTypePropagationSession() {
        return this.createTypePropagationSession(this.getArtifactAst());
    }

    public TypeBindingsResolutionSession createTypeBindingResolutionSession(ArtifactAst application) {
        return new DietBindingsResolutionSession(application);
    }

    public TypeBindingsResolutionSession createTypeBindingResolutionSession() {
        return this.createTypeBindingResolutionSession(this.getArtifactAst());
    }

    private ArtifactAst getArtifactAst() {
        return (ArtifactAst)this.mule.getArtifactAst().orElseThrow(() -> new IllegalStateException("There is no artifact AST available"));
    }

    public ValueProviderSession createValueProviderSession(ExtensionModel extensionModel, ParameterizedModel parameterizedModel) {
        return new DietValueProviderSession(this.mule, extensionModel, parameterizedModel, this.mule.getReflectionCache());
    }

    public SampleDataSession createSampleDataSession(ExtensionModel extensionModel) {
        return new DietSampleDataSession(this.mule, extensionModel);
    }

    public boolean evictFromMetadataStorage(ComponentParameterization<?> componentParameterization) {
        Optional<String> keyId = this.mule.getIdGenerator().getIdForMetadataKeys(componentParameterization).map(MetadataCacheId::getValue);
        Optional<String> componentId = this.mule.getIdGenerator().getIdForComponentMetadata(componentParameterization).map(MetadataCacheId::getValue);
        MetadataStorage storage = this.mule.getMetadataStorage();
        boolean evictKey = keyId.map(arg_0 -> ((MetadataStorage)storage).evictEntry(arg_0)).orElse(false);
        boolean evictComponent = componentId.map(arg_0 -> ((MetadataStorage)storage).evictEntry(arg_0)).orElse(false);
        return evictKey || evictComponent;
    }

    public IconsResult getIconsFor(ExtensionModel extensionModel) {
        return this.iconSession.getIconFor(extensionModel);
    }
}

