/*
 * Decompiled with CFR 0.152.
 */
package org.mule.framework.internal.tooling.type.bindings;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.mule.framework.api.tooling.type.bindings.TypeBindingsResolutionSession;
import org.mule.metadata.MetadataFormats;
import org.mule.metadata.api.builder.BaseTypeBuilder;
import org.mule.metadata.api.builder.FunctionTypeBuilder;
import org.mule.metadata.api.model.MetadataType;
import org.mule.metadata.message.api.el.ModuleDefinition;
import org.mule.metadata.message.api.el.ModuleIdentifier;
import org.mule.metadata.message.api.el.TypeBindings;
import org.mule.runtime.api.meta.model.ExtensionModel;
import org.mule.runtime.api.util.LazyValue;
import org.mule.runtime.ast.api.ArtifactAst;

public class DietBindingsResolutionSession
implements TypeBindingsResolutionSession {
    private final LazyValue<Map<String, MetadataType>> functionBindings = new LazyValue(() -> DietBindingsResolutionSession.createFunctionBindings(artifactAst));

    public DietBindingsResolutionSession(ArtifactAst artifactAst) {
    }

    public Map<String, MetadataType> getFunctionBindings() {
        return (Map)this.functionBindings.get();
    }

    private static Map<String, MetadataType> createFunctionBindings(ArtifactAst application) {
        TypeBindings.Builder functionBindingsBuilder = TypeBindings.builder();
        DietBindingsResolutionSession.registerDependenciesFunctions(functionBindingsBuilder, application);
        return DietBindingsResolutionSession.bindingsToMap(functionBindingsBuilder.build());
    }

    private static void registerDependenciesFunctions(TypeBindings.Builder functionBindings, ArtifactAst application) {
        application.dependencies().forEach(extensionModel -> {
            HashMap<String, MetadataType> functionsMap = new HashMap<String, MetadataType>();
            extensionModel.getFunctionModels().forEach(functionModel -> {
                FunctionTypeBuilder functionTypeBuilder = DietBindingsResolutionSession.getFunctionTypeBuilder();
                functionModel.getAllParameterModels().forEach(parameterModel -> functionTypeBuilder.addParameterOf(parameterModel.getName(), parameterModel.getType()));
                functionTypeBuilder.returnType(functionModel.getOutput().getType());
                functionsMap.put(functionModel.getName(), (MetadataType)functionTypeBuilder.build());
            });
            if (!functionsMap.isEmpty()) {
                ModuleDefinition.Builder module = functionBindings.module(DietBindingsResolutionSession.createModuleIdentifier(extensionModel));
                functionsMap.forEach((arg_0, arg_1) -> ((ModuleDefinition.Builder)module).addElement(arg_0, arg_1));
            }
        });
    }

    private static Map<String, MetadataType> bindingsToMap(TypeBindings typeBindings) {
        if (typeBindings == null) {
            return Collections.emptyMap();
        }
        HashMap result = new HashMap();
        typeBindings.identifiers().forEach(identifier -> typeBindings.lookup(identifier).ifPresent(metadataType -> result.put(identifier, metadataType)));
        typeBindings.modules().forEach(moduleDefinition -> {
            ModuleIdentifier moduleIdentifier = moduleDefinition.getName();
            moduleDefinition.identifiers().forEach(identifier -> moduleDefinition.lookup(identifier).ifPresent(metadataType -> result.put(moduleIdentifier + "::" + identifier, metadataType)));
        });
        return Collections.unmodifiableMap(result);
    }

    private static FunctionTypeBuilder getFunctionTypeBuilder() {
        return new BaseTypeBuilder(MetadataFormats.JAVA).functionType();
    }

    private static String createModuleIdentifier(ExtensionModel extensionModel) {
        return StringUtils.capitalize((String)extensionModel.getXmlDslModel().getPrefix());
    }
}

