/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.observability.configuration;

import java.io.File;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ObservabilityConfigurationFileWatcher
extends Thread {
    public static final String MULE_OBSERVABILITY_CONFIGURATION_WATCHER_DEFAULT_DELAY_PROPERTY = "mule.observability.configuration.configurationFileWatcherDelay";
    private static final Logger LOGGER = LoggerFactory.getLogger(ObservabilityConfigurationFileWatcher.class);
    public final long DEFAULT_DELAY;
    private final String filename;
    private final Runnable doOnChange;
    protected long delay;
    private final File file;
    private long lastModified;
    private boolean warnedAlready;

    public ObservabilityConfigurationFileWatcher(File file, Runnable doOnChange) {
        super("FileSpanExporterConfigurationWatcher");
        this.delay = this.DEFAULT_DELAY = Long.getLong(MULE_OBSERVABILITY_CONFIGURATION_WATCHER_DEFAULT_DELAY_PROPERTY, 60000L).longValue();
        this.filename = file.getName();
        this.file = file;
        this.doOnChange = doOnChange;
        this.lastModified = file.lastModified();
        this.setDaemon(true);
    }

    protected void checkAndConfigure() {
        boolean fileExists;
        try {
            fileExists = this.file.exists();
        }
        catch (SecurityException var4) {
            LOGGER.warn("The tracing config file {} was possibly removed.", (Object)this.filename);
            this.interrupt();
            return;
        }
        if (fileExists) {
            long fileLastMod = this.file.lastModified();
            if (fileLastMod > this.lastModified) {
                this.lastModified = fileLastMod;
                this.doOnChange();
                this.warnedAlready = false;
            }
        } else if (!this.warnedAlready) {
            LOGGER.warn("Configuration for file exporter was not found. It was possibly removed.");
            this.warnedAlready = true;
        }
    }

    @Override
    public void run() {
        while (!ObservabilityConfigurationFileWatcher.interrupted()) {
            try {
                this.checkAndConfigure();
                ObservabilityConfigurationFileWatcher.sleep(this.delay);
            }
            catch (InterruptedException var2) {
                return;
            }
        }
    }

    private void doOnChange() {
        this.doOnChange.run();
    }
}

