/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.mule.runtime.module.cluster.internal.config.persistence;

import com.hazelcast.config.Config;
import com.hazelcast.config.MapConfig;
import com.hazelcast.config.MapStoreConfig;
import com.mulesoft.mule.runtime.module.cluster.api.persistence.query.IdempotentTableNameTransformerStrategy;
import com.mulesoft.mule.runtime.module.cluster.internal.persistence.JdbcMapStoreFactory;
import java.util.Properties;
import org.mule.runtime.api.serialization.SerializationProtocol;

public final class JdbcMapStoreConfigConfigurator {
    private JdbcMapStoreConfigConfigurator() {
    }

    public static void configure(Config config, String jdbcUrl, String driverClassName, String username, String password, String queryStrategy, SerializationProtocol serializationProtocol, String tableNameTransformerStrategy, Properties clusterProperties) {
        MapConfig mapConfig = config.getMapConfig("*");
        MapStoreConfig mapStoreConfig = new MapStoreConfig();
        mapStoreConfig.setEnabled(true);
        mapStoreConfig.setWriteDelaySeconds(0);
        mapStoreConfig.setFactoryImplementation(new JdbcMapStoreFactory(jdbcUrl, driverClassName, username, password, queryStrategy, serializationProtocol, tableNameTransformerStrategy, clusterProperties));
        mapConfig.setMapStoreConfig(mapStoreConfig);
    }

    public static void configure(Config config, String jdbcUrl, String driverClassName, String username, String password, String queryStrategy, SerializationProtocol serializationProtocol) {
        JdbcMapStoreConfigConfigurator.configure(config, jdbcUrl, driverClassName, username, password, queryStrategy, serializationProtocol, IdempotentTableNameTransformerStrategy.class.getName(), new Properties());
    }
}

