/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.apikit.metadata.internal.amf;

import amf.apicontract.client.platform.model.domain.EndPoint;
import amf.apicontract.client.platform.model.domain.Operation;
import amf.apicontract.client.platform.model.domain.Parameter;
import amf.apicontract.client.platform.model.domain.Payload;
import amf.apicontract.client.platform.model.domain.Request;
import amf.apicontract.client.platform.model.domain.Response;
import amf.core.client.platform.model.domain.Shape;
import amf.shapes.client.platform.ShapesConfiguration;
import amf.shapes.client.platform.ShapesElementClient;
import amf.shapes.client.platform.model.domain.AnyShape;
import amf.shapes.client.platform.model.domain.Example;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.mule.metadata.api.builder.BaseTypeBuilder;
import org.mule.metadata.api.builder.FunctionTypeBuilder;
import org.mule.metadata.api.builder.ObjectTypeBuilder;
import org.mule.metadata.api.builder.TypeBuilder;
import org.mule.metadata.api.model.FunctionType;
import org.mule.metadata.api.model.MetadataFormat;
import org.mule.metadata.api.model.MetadataType;
import org.mule.metadata.api.model.ObjectType;
import org.mule.metadata.message.api.MessageMetadataType;
import org.mule.metadata.message.api.MessageMetadataTypeBuilder;
import org.mule.metadata.message.api.MuleEventMetadataType;
import org.mule.metadata.message.api.MuleEventMetadataTypeBuilder;
import org.mule.module.apikit.metadata.internal.amf.MetadataFactory;
import org.mule.module.apikit.metadata.internal.model.ApiCoordinate;
import org.mule.module.apikit.metadata.internal.model.CertificateFields;
import org.mule.module.apikit.metadata.internal.model.HttpRequestAttributesFields;
import org.mule.module.apikit.metadata.internal.utils.CommonMetadataFactory;
import org.mule.runtime.api.metadata.MediaType;
import org.mule.runtime.apikit.metadata.api.MetadataSource;
import org.mule.runtime.apikit.metadata.api.Notifier;

class FlowMetadata
implements MetadataSource {
    private static final String PARAMETER_INPUT_METADATA = "inputMetadata";
    private static final Pattern STATUS_CODE_2XX_PATTERN = Pattern.compile("^2\\d{2}$");
    private final EndPoint endPoint;
    private final Operation operation;
    private final ApiCoordinate coordinate;
    private final Map<String, Parameter> baseUriParameters;
    private final Notifier notifier;

    FlowMetadata(EndPoint endPoint, Operation operation, ApiCoordinate coordinate, Map<String, Parameter> baseUriParameters, Notifier notifier) {
        this.endPoint = endPoint;
        this.operation = operation;
        this.coordinate = coordinate;
        this.baseUriParameters = baseUriParameters;
        this.notifier = notifier;
    }

    public Optional<FunctionType> getMetadata() {
        MuleEventMetadataType input = this.inputMetadata(this.operation, this.coordinate, this.baseUriParameters);
        MuleEventMetadataType output = this.outputMetadata(this.operation, this.coordinate);
        FunctionTypeBuilder builder = BaseTypeBuilder.create((MetadataFormat)MetadataFormat.JAVA).functionType();
        FunctionType function = builder.addParameterOf(PARAMETER_INPUT_METADATA, (MetadataType)input).returnType((MetadataType)output).build();
        return Optional.of(function);
    }

    private MuleEventMetadataType inputMetadata(Operation operation, ApiCoordinate coordinate, Map<String, Parameter> baseUriParameters) {
        MessageMetadataType message = new MessageMetadataTypeBuilder().payload(this.getInputPayload(operation, coordinate)).attributes((MetadataType)this.getInputAttributes(operation, baseUriParameters)).build();
        return new MuleEventMetadataTypeBuilder().message(message).build();
    }

    private MuleEventMetadataType outputMetadata(Operation operation, ApiCoordinate coordinate) {
        MessageMetadataType message = new MessageMetadataTypeBuilder().payload(this.getOutputPayload(operation, coordinate)).build();
        return new MuleEventMetadataTypeBuilder().message(message).addVariable("outboundHeaders", (MetadataType)this.getOutputHeaders(operation).build()).addVariable("httpStatus", MetadataFactory.stringMetadata()).build();
    }

    private MetadataType getInputPayload(Operation operation, ApiCoordinate coordinate) {
        Request request = operation.request();
        if (request == null) {
            return CommonMetadataFactory.defaultMetadata();
        }
        List payloads = request.payloads();
        Optional<Payload> payload = FlowMetadata.findPayload(payloads, coordinate.getMediaType());
        return payload.map(p -> this.loadIOPayloadMetadata((Payload)p, coordinate, "input")).orElseGet(CommonMetadataFactory::defaultMetadata);
    }

    private MetadataType getOutputPayload(Operation operation, ApiCoordinate coordinate) {
        Optional<Response> response = FlowMetadata.findFirstResponse(operation);
        if (!response.isPresent()) {
            return CommonMetadataFactory.defaultMetadata();
        }
        List payloads = response.get().payloads();
        Optional<Payload> payload = FlowMetadata.findPayload(payloads, coordinate.getMediaType());
        return payload.map(p -> this.loadIOPayloadMetadata((Payload)p, coordinate, "output")).orElseGet(CommonMetadataFactory::defaultMetadata);
    }

    private ObjectTypeBuilder getOutputHeaders(Operation operation) {
        List<Parameter> headers = FlowMetadata.findFirstResponse(operation).map(Response::headers).orElse(Collections.emptyList());
        ObjectTypeBuilder builder = BaseTypeBuilder.create((MetadataFormat)MetadataFormat.JAVA).objectType();
        headers.forEach(header -> builder.addField().key(header.name().value().toLowerCase()).value(this.loadIOParameterMetadata((Parameter)header)).required(header.required().value()));
        return builder;
    }

    private ObjectType getInputAttributes(Operation operation, Map<String, Parameter> baseUrParameters) {
        ObjectTypeBuilder builder = BaseTypeBuilder.create((MetadataFormat)MetadataFormat.JAVA).objectType();
        builder.addField().key(HttpRequestAttributesFields.ATTRIBUTES_CLIENT_CERTIFICATE.getName()).required(false).value(FlowMetadata.getClientCertificate());
        builder.addField().key(HttpRequestAttributesFields.ATTRIBUTES_HEADERS.getName()).required(true).value((TypeBuilder)this.getInputHeaders(operation));
        builder.addField().key(HttpRequestAttributesFields.ATTRIBUTES_LISTENER_PATH.getName()).required(true).value(MetadataFactory.stringMetadata());
        builder.addField().key(HttpRequestAttributesFields.ATTRIBUTES_METHOD.getName()).required(true).value(MetadataFactory.stringMetadata());
        builder.addField().key(HttpRequestAttributesFields.ATTRIBUTES_QUERY_PARAMS.getName()).required(true).value((TypeBuilder)this.getQueryParameters(operation));
        builder.addField().key(HttpRequestAttributesFields.ATTRIBUTES_QUERY_STRING.getName()).required(true).value(MetadataFactory.stringMetadata());
        builder.addField().key(HttpRequestAttributesFields.ATTRIBUTES_RELATIVE_PATH.getName()).required(true).value(MetadataFactory.stringMetadata());
        builder.addField().key(HttpRequestAttributesFields.ATTRIBUTES_REMOTE_ADDRESS.getName()).required(true).value(MetadataFactory.stringMetadata());
        builder.addField().key(HttpRequestAttributesFields.ATTRIBUTES_REQUEST_PATH.getName()).required(true).value(MetadataFactory.stringMetadata());
        builder.addField().key(HttpRequestAttributesFields.ATTRIBUTES_REQUEST_URI.getName()).required(true).value(MetadataFactory.stringMetadata());
        builder.addField().key(HttpRequestAttributesFields.ATTRIBUTES_SCHEME.getName()).required(true).value(MetadataFactory.stringMetadata());
        builder.addField().key(HttpRequestAttributesFields.ATTRIBUTES_URI_PARAMS.getName()).required(true).value((TypeBuilder)this.getUriParameters(this.endPoint, operation, baseUrParameters));
        builder.addField().key(HttpRequestAttributesFields.ATTRIBUTES_VERSION.getName()).required(true).value(MetadataFactory.stringMetadata());
        builder.addField().key(HttpRequestAttributesFields.ATTRIBUTES_LOCAL_ADDRESS.getName()).required(true).value(MetadataFactory.stringMetadata());
        return builder.build();
    }

    private ObjectTypeBuilder getInputHeaders(Operation operation) {
        ObjectTypeBuilder builder = BaseTypeBuilder.create((MetadataFormat)MetadataFormat.JAVA).objectType();
        Request request = operation.request();
        if (request != null) {
            request.headers().forEach(header -> builder.addField().key(header.name().value()).value(this.loadIOParameterMetadata((Parameter)header)).required(header.required().value()));
        }
        return builder;
    }

    private static MetadataType getClientCertificate() {
        ObjectTypeBuilder builder = BaseTypeBuilder.create((MetadataFormat)MetadataFormat.JAVA).objectType();
        builder.addField().key(CertificateFields.CLIENT_CERTIFICATE_PUBLIC_KEY.getName()).value(MetadataFactory.objectMetadata());
        builder.addField().key(CertificateFields.CLIENT_CERTIFICATE_TYPE.getName()).value(MetadataFactory.stringMetadata());
        builder.addField().key(CertificateFields.CLIENT_CERTIFICATE_ENCODED.getName()).value(MetadataFactory.binaryMetadata());
        return builder.build();
    }

    private ObjectTypeBuilder getQueryParameters(Operation operation) {
        ObjectTypeBuilder builder = BaseTypeBuilder.create((MetadataFormat)MetadataFormat.JAVA).objectType();
        Request request = operation.request();
        if (request != null) {
            request.queryParameters().forEach(param -> builder.addField().key(param.name().value()).value(this.loadIOParameterMetadata((Parameter)param)).required(param.required().value()));
        }
        return builder;
    }

    private ObjectTypeBuilder getUriParameters(EndPoint endPoint, Operation operation, Map<String, Parameter> baseUriParameters) {
        ObjectTypeBuilder builder = BaseTypeBuilder.create((MetadataFormat)MetadataFormat.JAVA).objectType();
        LinkedHashMap<String, Parameter> parameters = new LinkedHashMap<String, Parameter>(baseUriParameters);
        parameters.putAll(this.getEndpointUriParametersFields(endPoint));
        parameters.putAll(this.getUriParametersFromOperation(operation));
        Predicate<Map.Entry> versionFilter = e -> !"version".equals(e.getKey());
        Consumer<Parameter> addParameterToBuilder = p -> builder.addField().key(p.name().value()).value(this.loadIOParameterMetadata((Parameter)p)).required(p.required().value());
        parameters.entrySet().stream().filter(versionFilter).map(e -> (Parameter)e.getValue()).forEach(addParameterToBuilder);
        return builder;
    }

    private Map<String, Parameter> getEndpointUriParametersFields(EndPoint endPoint) {
        List endPointParameters = endPoint.parameters();
        return CollectionUtils.isEmpty((Collection)endPointParameters) ? Collections.emptyMap() : (Map)endPointParameters.stream().collect(LinkedHashMap::new, (map, param) -> map.put(param.name().value(), param), Map::putAll);
    }

    private Map<String, Parameter> getUriParametersFromOperation(Operation operation) {
        LinkedHashMap<String, Parameter> uriParams = new LinkedHashMap<String, Parameter>();
        List<Parameter> requestUriParams = operation.requests().stream().map(r -> r.uriParameters()).flatMap(Collection::stream).collect(Collectors.toList());
        requestUriParams.forEach(p -> uriParams.put(p.name().value(), (Parameter)p));
        return uriParams;
    }

    private static Optional<Response> findFirstResponse(Operation operation) {
        return operation.responses().stream().filter(response -> STATUS_CODE_2XX_PATTERN.matcher(response.statusCode().value()).matches() && !response.payloads().isEmpty()).findFirst();
    }

    private static Optional<Payload> findPayload(List<Payload> payloads, String mediaType) {
        if (payloads.isEmpty()) {
            return Optional.empty();
        }
        if (payloads.size() == 1 || mediaType == null) {
            return Optional.of(payloads.get(0));
        }
        MediaType mType = MediaType.parse((String)mediaType);
        return payloads.stream().filter(p -> MediaType.parse((String)p.mediaType().value()).matches(mType)).findFirst();
    }

    private MetadataType loadIOParameterMetadata(Parameter parameter) {
        try {
            Example example = this.getFirstExample(parameter.schema()).orElse(null);
            ShapesElementClient client = ShapesConfiguration.predefined().elementClient();
            return MetadataFactory.fromJSONSchema(parameter.schema(), example != null ? client.renderExample(example, MediaType.APPLICATION_JSON.toString()) : "");
        }
        catch (Exception e) {
            this.notifier.warn(String.format("Error while trying to resolve metadata for parameter '%s'\nDetails: %s", parameter.name(), e.getMessage()));
            return MetadataFactory.defaultMetadata(parameter.schema());
        }
    }

    private MetadataType loadIOPayloadMetadata(Payload payload, ApiCoordinate coordinate, String payloadDescription) {
        try {
            String mediaType = payload.mediaType().option().orElse("").toLowerCase();
            Example example = this.getFirstExample(payload.schema()).orElse(null);
            ShapesElementClient client = ShapesConfiguration.predefined().elementClient();
            return mediaType.contains("xml") ? MetadataFactory.fromXSDSchema(payload.schema(), example != null ? example.value().value() : "") : MetadataFactory.fromJSONSchema(payload.schema(), example != null ? client.renderExample(example, MediaType.APPLICATION_JSON.toString()) : "");
        }
        catch (Exception e) {
            this.notifier.warn(String.format("Error while trying to resolve %s payload metadata for flow '%s'.\nDetails: %s", payloadDescription, coordinate.getFlowName(), e.getMessage()));
            return MetadataFactory.defaultMetadata(payload.schema());
        }
    }

    private Optional<Example> getFirstExample(Shape schema) {
        List examples;
        if (schema instanceof AnyShape && (examples = ((AnyShape)schema).examples()) != null && !examples.isEmpty()) {
            return Optional.of(examples.get(0));
        }
        return Optional.empty();
    }
}

