/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.apikit.metadata.internal.model;

import java.util.List;
import java.util.Optional;
import org.mule.module.apikit.metadata.internal.amf.AmfHandler;
import org.mule.module.apikit.metadata.internal.amf.AutoHandler;
import org.mule.module.apikit.metadata.internal.model.FlowMapping;
import org.mule.module.apikit.metadata.internal.model.MetadataResolver;
import org.mule.module.apikit.metadata.internal.model.MetadataResolverFactory;
import org.mule.module.apikit.metadata.internal.raml.RamlHandler;
import org.mule.parser.service.ParserMode;
import org.mule.runtime.apikit.metadata.api.Notifier;
import org.mule.runtime.apikit.metadata.api.ResourceLoader;

class ApikitConfig {
    private final String name;
    private final String apiDefinition;
    private final List<FlowMapping> flowMappings;
    private final String httpStatusVarName;
    private final String outputHeadersVarName;
    private final String parser;
    private final ResourceLoader resourceLoader;
    private final Notifier notifier;
    private MetadataResolverFactory metadataResolverFactory = null;
    private MetadataResolver metadataResolver;

    ApikitConfig(String name, String apiDefinition, List<FlowMapping> flowMappings, String httpStatusVarName, String outputHeadersVarName, String parser, ResourceLoader resourceLoader, Notifier notifier) {
        this.name = name;
        this.apiDefinition = apiDefinition;
        this.flowMappings = flowMappings;
        this.httpStatusVarName = httpStatusVarName;
        this.outputHeadersVarName = outputHeadersVarName;
        this.parser = parser;
        this.resourceLoader = resourceLoader;
        this.notifier = notifier;
    }

    public String getName() {
        return this.name;
    }

    public List<FlowMapping> getFlowMappings() {
        return this.flowMappings;
    }

    public String getHttpStatusVarName() {
        return this.httpStatusVarName;
    }

    public String getOutputHeadersVarName() {
        return this.outputHeadersVarName;
    }

    public Optional<MetadataResolver> getMetadataResolver() {
        if (this.metadataResolver == null) {
            this.getMetadataResolverFactory().getMetadataResolver(this.apiDefinition).ifPresent(resolver -> {
                this.metadataResolver = resolver;
            });
        }
        return Optional.ofNullable(this.metadataResolver);
    }

    private MetadataResolverFactory getMetadataResolverFactory() {
        if (this.metadataResolverFactory == null) {
            ParserMode parserType = ApikitConfig.getParserMode(this.parser);
            switch (parserType) {
                case RAML: {
                    this.metadataResolverFactory = new RamlHandler(this.resourceLoader, this.notifier);
                    break;
                }
                case AMF: {
                    this.metadataResolverFactory = new AmfHandler(this.resourceLoader, this.notifier);
                    break;
                }
                default: {
                    this.metadataResolverFactory = new AutoHandler(this.resourceLoader, this.notifier);
                }
            }
        }
        return this.metadataResolverFactory;
    }

    private static ParserMode getParserMode(String parser) {
        String value = System.getProperty("mule.apikit.parser", parser);
        return value != null ? ParserMode.valueOf((String)value) : ParserMode.AUTO;
    }
}

