/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.runtime.introspector.internal.extractor;

import com.mulesoft.runtime.introspector.IntrospectionResult;
import com.mulesoft.runtime.introspector.IntrospectionResults;
import com.mulesoft.runtime.introspector.exception.IntrospectionException;
import com.mulesoft.runtime.introspector.internal.extractor.NativeLibrariesSupportDataExtractor;
import com.mulesoft.runtime.introspector.internal.extractor.file.ArtifactPathWalker;
import com.mulesoft.runtime.introspector.internal.extractor.file.ExplodedArtifactPathWalker;
import com.mulesoft.runtime.introspector.internal.extractor.file.NoOpArtifactPathWalker;
import com.mulesoft.runtime.introspector.internal.extractor.file.ZipArtifactPathWalker;
import com.mulesoft.runtime.introspector.internal.extractor.flow.FlowsDataExtractor;
import com.mulesoft.runtime.introspector.internal.extractor.java.JavaComponentsDataExtractor;
import com.mulesoft.runtime.introspector.internal.extractor.property.ConfigPropertiesDataExtractor;
import com.mulesoft.runtime.introspector.internal.extractor.schedulers.SchedulersDataExtractor;
import com.mulesoft.runtime.introspector.internal.model.builder.IntrospectionResultBuilder;
import java.nio.file.Path;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.function.Consumer;
import org.mule.runtime.ast.api.ArtifactAst;
import org.mule.runtime.module.artifact.activation.api.deployable.DeployableProjectModel;

public class MuleArtifactDataExtractor {
    private final FlowsDataExtractor flowsDataExtractor = new FlowsDataExtractor();
    private final SchedulersDataExtractor schedulersDataExtractor = new SchedulersDataExtractor();
    private final ConfigPropertiesDataExtractor configPropertiesDataExtractor = new ConfigPropertiesDataExtractor();
    private final NativeLibrariesSupportDataExtractor nativeLibrariesSupportDataExtractor = new NativeLibrariesSupportDataExtractor();
    private final JavaComponentsDataExtractor javaComponentsDataExtractor = new JavaComponentsDataExtractor();

    public IntrospectionResult extractFrom(CompletableFuture<ArtifactAst> artifactFuture, CompletableFuture<ClassLoader> artifactClassloaderFuture, CompletableFuture<Optional<DeployableProjectModel>> deployableProjectModelFuture, Optional<Path> artifactPath, Set<IntrospectionResults> wantedResults, Executor executor) throws IntrospectionException {
        ArtifactPathWalker artifactPathWalker = this.createArtifactPathWalkerVisitor(executor, artifactPath);
        this.runIfWanted(IntrospectionResults.NATIVE_LIBRARIES, wantedResults, () -> artifactPathWalker.registerVisitor(this.nativeLibrariesSupportDataExtractor));
        this.runIfWanted(IntrospectionResults.JAVA_COMPONENTS, wantedResults, () -> artifactPathWalker.registerVisitor(this.javaComponentsDataExtractor));
        artifactPathWalker.walk();
        IntrospectionResultBuilder resultBuilder = new IntrospectionResultBuilder();
        try {
            ArtifactAst artifact = artifactFuture.get();
            ClassLoader artifactClassloader = artifactClassloaderFuture.get();
            Optional<DeployableProjectModel> deployableProjectModel = deployableProjectModelFuture.get();
            this.extractResult(IntrospectionResults.FLOWS, wantedResults, resultBuilder::setFlows, () -> this.flowsDataExtractor.extractFrom(artifact));
            this.extractResult(IntrospectionResults.SCHEDULERS, wantedResults, resultBuilder::setSchedulers, () -> this.schedulersDataExtractor.extractFrom(artifact));
            this.extractResult(IntrospectionResults.CONFIG_PROPERTIES, wantedResults, resultBuilder::setConfigProperties, () -> this.configPropertiesDataExtractor.extractFrom(artifact, artifactClassloader));
            this.extractResult(IntrospectionResults.NATIVE_LIBRARIES, wantedResults, resultBuilder::setNativeLibraries, () -> this.nativeLibrariesSupportDataExtractor.extract(artifactPathWalker));
            this.extractResult(IntrospectionResults.JAVA_COMPONENTS, wantedResults, resultBuilder::setJavaComponents, () -> this.javaComponentsDataExtractor.extractFrom(artifact, artifactClassloader, deployableProjectModel, artifactPathWalker));
        }
        catch (IntrospectionException e) {
            throw e;
        }
        catch (ExecutionException e) {
            throw new IntrospectionException(e.getCause());
        }
        catch (InterruptedException e) {
            Thread.interrupted();
            throw new IntrospectionException(e);
        }
        catch (Exception e) {
            throw new IntrospectionException(e);
        }
        return resultBuilder.build();
    }

    private ArtifactPathWalker createArtifactPathWalkerVisitor(Executor executor, Optional<Path> artifactPath) {
        return artifactPath.map(p -> {
            if (p.toFile().isDirectory()) {
                return new ExplodedArtifactPathWalker(executor, (Path)artifactPath.get());
            }
            return new ZipArtifactPathWalker(executor, (Path)artifactPath.get());
        }).orElseGet(() -> new NoOpArtifactPathWalker());
    }

    private void runIfWanted(IntrospectionResults resultKey, Set<IntrospectionResults> wantedResults, Runnable resultValueSupplier) throws IntrospectionException {
        if (wantedResults.isEmpty() || wantedResults.contains((Object)resultKey)) {
            resultValueSupplier.run();
        }
    }

    private <T> void extractResult(IntrospectionResults resultKey, Set<IntrospectionResults> wantedResults, Consumer<T> resultSetter, IntrospectionSupplier<Object> resultValueSupplier) throws IntrospectionException {
        if (wantedResults.isEmpty() || wantedResults.contains((Object)resultKey)) {
            resultSetter.accept(resultValueSupplier.get());
        }
    }

    @FunctionalInterface
    private static interface IntrospectionSupplier<T> {
        public T get() throws IntrospectionException;
    }
}

