/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.runtime.introspector.internal.extractor.nativelib.elf;

import com.mulesoft.runtime.introspector.internal.extractor.nativelib.Architecture;
import com.mulesoft.runtime.introspector.internal.extractor.nativelib.NativeLibraryReader;
import com.mulesoft.runtime.introspector.internal.extractor.nativelib.elf.ELFArchitecture;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.FileChannel;
import java.nio.file.Path;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NativeLibraryELFReader
implements NativeLibraryReader {
    private static final Logger LOGGER = LoggerFactory.getLogger(NativeLibraryELFReader.class);
    private static final int EI_CLASS = 4;
    private static final int EI_DATA = 5;

    @Override
    public Architecture getArchitecture(Path libFilePath) throws IOException {
        File soFile = libFilePath.toFile();
        try (FileInputStream fis = new FileInputStream(soFile);){
            Architecture architecture;
            block11: {
                FileChannel fileChannel = fis.getChannel();
                try {
                    ByteBuffer buffer = ByteBuffer.allocate(64);
                    fileChannel.read(buffer);
                    buffer.flip();
                    architecture = this.doGetArchitecture(libFilePath.toString(), buffer);
                    if (fileChannel == null) break block11;
                }
                catch (Throwable throwable) {
                    if (fileChannel != null) {
                        try {
                            fileChannel.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                fileChannel.close();
            }
            return architecture;
        }
    }

    @Override
    public Architecture getArchitecture(InputStream libFileStream, String libFilePath) throws IOException {
        byte[] headerBytes = new byte[64];
        int size = libFileStream.read(headerBytes);
        ByteBuffer buffer = ByteBuffer.wrap(headerBytes, 0, size);
        return this.doGetArchitecture(libFilePath, buffer);
    }

    private Architecture doGetArchitecture(String libFileName, ByteBuffer elfHeader) {
        if (this.isElf(elfHeader)) {
            LOGGER.error("Unable to read native library file {}, not an ELF file ", (Object)libFileName);
            return Architecture.UNKNOWN;
        }
        int elfClass = elfHeader.get(4) & 0xFF;
        int elfData = elfHeader.get(5) & 0xFF;
        ByteOrder byteOrder = ByteOrder.LITTLE_ENDIAN;
        elfHeader.order(byteOrder);
        elfHeader.position(18);
        short machineValue = elfHeader.getShort();
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Retrieved machine value {} from {}", (Object)machineValue, (Object)libFileName);
        }
        return ELFArchitecture.resolve(machineValue);
    }

    private boolean isElf(ByteBuffer elfHeader) {
        return elfHeader.get(0) != 127 || elfHeader.get(1) != 69 || elfHeader.get(2) != 76 || elfHeader.get(3) != 70;
    }
}

