/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.client.api.configuration.ssl;

import java.io.File;
import java.util.Objects;
import org.mule.tooling.client.internal.configuration.ssl.ImmutableTrustStoreConfig;

public interface TrustStoreConfig {
    public File getTrustStoreFile();

    public String getTrustStorePassword();

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private File trustStoreFile;
        private String trustStorePassword;

        public Builder withTrustStoreFile(File trustStoreFile) {
            Objects.requireNonNull(trustStoreFile, "trustStoreFile cannot be null");
            this.trustStoreFile = trustStoreFile;
            return this;
        }

        public Builder withTrustStorePassword(String trustStorePassword) {
            Objects.requireNonNull(trustStorePassword, "trustStorePassword cannot be null");
            this.trustStorePassword = trustStorePassword;
            return this;
        }

        public TrustStoreConfig build() {
            return new ImmutableTrustStoreConfig(this.trustStoreFile, this.trustStorePassword);
        }
    }
}

