/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.client.api.extension.model.parameter;

import java.util.List;
import java.util.Optional;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.mule.tooling.client.api.extension.model.DisplayModel;
import org.mule.tooling.client.api.extension.model.LayoutModel;
import org.mule.tooling.client.api.extension.model.parameter.ExclusiveParametersModel;
import org.mule.tooling.client.api.extension.model.parameter.ParameterModel;

public class ParameterGroupModel {
    public static String DEFAULT_GROUP_NAME = "General";
    public static String ADVANCED = "Advanced";
    public static String OUTPUT = "Output";
    public static String CONNECTION = "Connection";
    private String name;
    private String description;
    private DisplayModel displayModel;
    private LayoutModel layoutModel;
    private List<ParameterModel> parameterModels;
    private List<ExclusiveParametersModel> exclusiveParametersModels;
    private boolean showInDsl;

    private ParameterGroupModel() {
    }

    public ParameterGroupModel(String name, String description, DisplayModel displayModel, LayoutModel layoutModel, List<ParameterModel> parameterModels, List<ExclusiveParametersModel> exclusiveParametersModels, boolean showInDsl) {
        this.name = name;
        this.description = description;
        this.displayModel = displayModel;
        this.layoutModel = layoutModel;
        this.parameterModels = parameterModels;
        this.exclusiveParametersModels = exclusiveParametersModels;
        this.showInDsl = showInDsl;
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public Optional<DisplayModel> getDisplayModel() {
        return Optional.ofNullable(this.displayModel);
    }

    public Optional<LayoutModel> getLayoutModel() {
        return Optional.ofNullable(this.layoutModel);
    }

    public List<ParameterModel> getParameterModels() {
        return this.parameterModels;
    }

    public List<ExclusiveParametersModel> getExclusiveParametersModels() {
        return this.exclusiveParametersModels;
    }

    public boolean isShowInDsl() {
        return this.showInDsl;
    }

    public Optional<ParameterModel> getParameterModel(String name) {
        return this.parameterModels.stream().filter(model -> model.getName().equals(name)).findFirst();
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public boolean equals(Object obj) {
        return this.getClass().isInstance(obj) && this.name.equals(((ParameterGroupModel)obj).getName());
    }

    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this);
    }
}

